/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.DataUtilities;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PublicCloneable;

public class StackedBarRenderer
extends BarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = 6402943811500067531L;
    private boolean renderAsPercentages;

    public StackedBarRenderer() {
        this(false);
    }

    public StackedBarRenderer(boolean bl) {
        this.renderAsPercentages = bl;
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        this.setBasePositiveItemLabelPosition(itemLabelPosition);
        this.setBaseNegativeItemLabelPosition(itemLabelPosition);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public int getPassCount() {
        return 2;
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(categoryDataset);
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = categoryPlot.getDomainAxisForDataset(n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = d * this.getMaxBarWidth();
            int n2 = categoryDataset.getColumnCount();
            double d3 = 0.0;
            if (n2 > 1) {
                d3 = categoryAxis.getCategoryMargin();
            }
            double d4 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d3);
            if (n2 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d4 / (double)n2, d2));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d4, d2));
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d;
        double d2;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d3 = number.doubleValue();
        double d4 = 0.0;
        if (this.renderAsPercentages) {
            d4 = DataUtilities.calculateColumnTotal(categoryDataset, n2);
            d3 /= d4;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d5 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number2 = categoryDataset.getValue(i, n2);
            if (number2 == null) continue;
            d2 = number2.doubleValue();
            if (this.renderAsPercentages) {
                d2 /= d4;
            }
            if (d2 > 0.0) {
                d6 += d2;
                continue;
            }
            d7 += d2;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        if (d3 >= 0.0) {
            d = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge);
            d2 = valueAxis.valueToJava2D(d6 + d3, rectangle2D, rectangleEdge);
        } else {
            d = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
            d2 = valueAxis.valueToJava2D(d7 + d3, rectangle2D, rectangleEdge);
        }
        double d8 = Math.min(d, d2);
        double d9 = Math.max(Math.abs(d2 - d), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d8, d5, d9, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d5, d8, categoryItemRendererState.getBarWidth(), d9);
        if (n3 == 0) {
            EntityCollection entityCollection;
            Paint paint = this.getItemPaint(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
                String string = null;
                CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (categoryToolTipGenerator != null) {
                    string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                entityCollection.add(categoryItemEntity);
            }
        } else if (n3 == 1 && (categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d3 < 0.0);
        }
    }
}

