/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class LineAndShapeRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -197749519869226398L;
    private boolean linesVisible;
    private boolean shapesVisible;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private boolean defaultShapesFilled;
    private boolean useFillPaint;
    private boolean drawOutlines;
    private boolean useOutlinePaint;

    public LineAndShapeRenderer() {
        this(true, true);
    }

    public LineAndShapeRenderer(boolean bl, boolean bl2) {
        this.linesVisible = bl;
        this.shapesVisible = bl2;
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.defaultShapesFilled = true;
        this.useFillPaint = false;
        this.drawOutlines = true;
        this.useOutlinePaint = false;
    }

    public boolean isLinesVisible() {
        return this.linesVisible;
    }

    public void setLinesVisible(boolean bl) {
        if (bl != this.linesVisible) {
            this.linesVisible = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean isShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(boolean bl) {
        if (bl != this.shapesVisible) {
            this.shapesVisible = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean bl) {
        this.drawOutlines = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean bl) {
        this.useOutlinePaint = bl;
    }

    public boolean getItemShapeFilled(int n, int n2) {
        return this.getSeriesShapesFilled(n);
    }

    public boolean getSeriesShapesFilled(int n) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean bl = this.seriesShapesFilled.getBoolean(n);
        if (bl != null) {
            return bl;
        }
        return this.defaultShapesFilled;
    }

    public Boolean getShapesFilled() {
        return this.shapesFilled;
    }

    public void setShapesFilled(boolean bl) {
        if (bl) {
            this.setShapesFilled(Boolean.TRUE);
        } else {
            this.setShapesFilled(Boolean.FALSE);
        }
    }

    public void setShapesFilled(Boolean bl) {
        this.shapesFilled = bl;
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
    }

    public void setSeriesShapesFilled(int n, boolean bl) {
        this.seriesShapesFilled.setBoolean(n, BooleanUtilities.valueOf(bl));
    }

    public boolean getDefaultShapesFilled() {
        return this.defaultShapesFilled;
    }

    public void setDefaultShapesFilled(boolean bl) {
        this.defaultShapesFilled = bl;
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl) {
        this.useFillPaint = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public LegendItem getLegendItem(int n, int n2) {
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (this.isSeriesVisible(n2) && this.isSeriesVisibleInLegend(n2)) {
            String string;
            CategoryDataset categoryDataset = categoryPlot.getDataset(n);
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n2);
            }
            Shape shape = this.getSeriesShape(n2);
            Paint paint = this.getSeriesPaint(n2);
            Paint paint2 = this.useFillPaint ? this.getItemFillPaint(n2, 0) : paint;
            boolean bl = this.drawOutlines;
            Paint paint3 = this.useOutlinePaint ? this.getItemOutlinePaint(n2, 0) : paint;
            Stroke stroke = this.getSeriesOutlineStroke(n2);
            return new LegendItem(string, string2, string3, string4, this.isShapesVisible(), shape, this.getItemShapeFilled(n2, 0), paint2, bl, paint3, stroke, this.isLinesVisible(), new Line2D.Double(-7.0, 0.0, 7.0, 0.0), this.getItemStroke(n2, 0), this.getItemPaint(n2, 0));
        }
        return null;
    }

    public int getPassCount() {
        return 2;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Object object;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d2 = number.doubleValue();
        double d3 = valueAxis.valueToJava2D(d2, rectangle2D, categoryPlot.getRangeAxisEdge());
        if (n3 == 0 && this.isLinesVisible() && n2 != 0 && (object = categoryDataset.getValue(n, n2 - 1)) != null) {
            double d4 = ((Number)object).doubleValue();
            double d5 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d6 = valueAxis.valueToJava2D(d4, rectangle2D, categoryPlot.getRangeAxisEdge());
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d6, d5, d3, d);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d5, d6, d, d3);
            }
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.draw(double_);
        }
        if (n3 == 1) {
            EntityCollection entityCollection;
            object = this.getItemShape(n, n2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, d3, d);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, d, d3);
            }
            if (this.isShapesVisible()) {
                if (this.getItemShapeFilled(n, n2)) {
                    if (this.useFillPaint) {
                        graphics2D.setPaint(this.getItemFillPaint(n, n2));
                    } else {
                        graphics2D.setPaint(this.getItemPaint(n, n2));
                    }
                    graphics2D.fill((Shape)object);
                }
                if (this.drawOutlines) {
                    if (this.useOutlinePaint) {
                        graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                    } else {
                        graphics2D.setPaint(this.getItemPaint(n, n2));
                    }
                    graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
                    graphics2D.draw((Shape)object);
                }
            }
            if (this.isItemLabelVisible(n, n2)) {
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d3, d, d2 < 0.0);
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d, d3, d2 < 0.0);
                }
            }
            if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null && object != null) {
                String string = null;
                CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (categoryToolTipGenerator != null) {
                    string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity((Shape)object, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                entityCollection.add(categoryItemEntity);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof LineAndShapeRenderer)) {
            return false;
        }
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)object;
        if (this.linesVisible != lineAndShapeRenderer.linesVisible) {
            return false;
        }
        if (this.shapesVisible != lineAndShapeRenderer.shapesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shapesFilled, lineAndShapeRenderer.shapesFilled)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesShapesFilled, lineAndShapeRenderer.seriesShapesFilled)) {
            return false;
        }
        if (this.defaultShapesFilled != lineAndShapeRenderer.defaultShapesFilled) {
            return false;
        }
        return this.useOutlinePaint == lineAndShapeRenderer.useOutlinePaint;
    }

    public Object clone() throws CloneNotSupportedException {
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)super.clone();
        lineAndShapeRenderer.seriesShapesFilled = (BooleanList)this.seriesShapesFilled.clone();
        return lineAndShapeRenderer;
    }
}

