/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.plot.PlotRenderingInfo;

public class PlotRenderingInfoTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PlotRenderingInfoTests.class);
    }

    public PlotRenderingInfoTests(String string) {
        super(string);
    }

    public void testEquals() {
        PlotRenderingInfo plotRenderingInfo = new PlotRenderingInfo(new ChartRenderingInfo());
        PlotRenderingInfo plotRenderingInfo2 = new PlotRenderingInfo(new ChartRenderingInfo());
        PlotRenderingInfoTests.assertTrue((boolean)plotRenderingInfo.equals(plotRenderingInfo2));
        PlotRenderingInfoTests.assertTrue((boolean)plotRenderingInfo2.equals(plotRenderingInfo));
    }

    public void testCloning() {
        PlotRenderingInfo plotRenderingInfo = new PlotRenderingInfo(new ChartRenderingInfo());
        PlotRenderingInfo plotRenderingInfo2 = null;
        try {
            plotRenderingInfo2 = (PlotRenderingInfo)plotRenderingInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("PiePlotTests.testCloning: failed to clone.");
        }
        PlotRenderingInfoTests.assertTrue((plotRenderingInfo != plotRenderingInfo2 ? 1 : 0) != 0);
        PlotRenderingInfoTests.assertTrue((plotRenderingInfo.getClass() == plotRenderingInfo2.getClass() ? 1 : 0) != 0);
        PlotRenderingInfoTests.assertTrue((boolean)plotRenderingInfo.equals(plotRenderingInfo2));
    }

    public void testSerialization() {
        PlotRenderingInfo plotRenderingInfo = new PlotRenderingInfo(new ChartRenderingInfo());
        PlotRenderingInfo plotRenderingInfo2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(plotRenderingInfo);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            plotRenderingInfo2 = (PlotRenderingInfo)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        PlotRenderingInfoTests.assertEquals((Object)plotRenderingInfo, plotRenderingInfo2);
    }
}

