/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.util.Rotation;

public class PiePlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PiePlotTests.class);
    }

    public PiePlotTests(String string) {
        super(string);
    }

    public void testEquals() {
        PiePlot piePlot = new PiePlot();
        PiePlot piePlot2 = new PiePlot();
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        PiePlotTests.assertTrue((boolean)piePlot2.equals(piePlot));
        piePlot.setPieIndex(99);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setPieIndex(99);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setInteriorGap(0.15);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setInteriorGap(0.15);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setCircular(!piePlot.isCircular());
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setCircular(false);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setStartAngle(Math.PI);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setStartAngle(Math.PI);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setDirection(Rotation.ANTICLOCKWISE);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setDirection(Rotation.ANTICLOCKWISE);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setIgnoreZeroValues(true);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setIgnoreZeroValues(true);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setIgnoreNullValues(true);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setIgnoreNullValues(true);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setSectionPaint(Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setSectionPaint(Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setSectionPaint(2, Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setSectionPaint(2, Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setBaseSectionPaint(Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setBaseSectionPaint(Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setSectionOutlinePaint(Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setSectionOutlinePaint(Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setSectionOutlinePaint(2, Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setSectionOutlinePaint(2, Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setBaseSectionOutlinePaint(Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setBaseSectionOutlinePaint(Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setSectionOutlineStroke(new BasicStroke(1.0f));
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setSectionOutlineStroke(new BasicStroke(1.0f));
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setSectionOutlineStroke(2, new BasicStroke(1.0f));
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setSectionOutlineStroke(2, new BasicStroke(1.0f));
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setBaseSectionOutlineStroke(new BasicStroke(1.0f));
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setBaseSectionOutlineStroke(new BasicStroke(1.0f));
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setShadowPaint(Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setShadowPaint(Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setShadowXOffset(4.4);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setShadowXOffset(4.4);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setShadowYOffset(4.4);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setShadowYOffset(4.4);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelFont(new Font("Serif", 0, 18));
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelFont(new Font("Serif", 0, 18));
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelPaint(Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelPaint(Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelBackgroundPaint(Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelBackgroundPaint(Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelOutlinePaint(Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelOutlinePaint(Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        BasicStroke basicStroke = new BasicStroke(1.1f);
        piePlot.setLabelOutlineStroke(basicStroke);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelOutlineStroke(basicStroke);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelShadowPaint(Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelShadowPaint(Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setExplodePercent(3, 0.33);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setExplodePercent(3, 0.33);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        Font font = new Font("SansSerif", 0, 20);
        piePlot.setLabelFont(font);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelFont(font);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelPaint(Color.blue);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelPaint(Color.blue);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setMaximumLabelWidth(0.33);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setMaximumLabelWidth(0.33);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelGap(0.11);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelGap(0.11);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelLinksVisible(false);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelLinksVisible(false);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelLinkMargin(0.11);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelLinkMargin(0.11);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelLinkPaint(Color.red);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelLinkPaint(Color.red);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLabelLinkStroke(new BasicStroke(1.0f));
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLabelLinkStroke(new BasicStroke(1.0f));
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setToolTipGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setToolTipGenerator(new StandardPieItemLabelGenerator("{2}{1}{0}"));
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setURLGenerator(new StandardPieURLGenerator("xx"));
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setURLGenerator(new StandardPieURLGenerator("xx"));
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setMinimumArcAngleToDraw(1.0);
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setMinimumArcAngleToDraw(1.0);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
        piePlot.setLegendItemShape(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        PiePlotTests.assertFalse((boolean)piePlot.equals(piePlot2));
        piePlot2.setLegendItemShape(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
    }

    public void testCloning() {
        PiePlot piePlot = new PiePlot();
        PiePlot piePlot2 = null;
        try {
            piePlot2 = (PiePlot)piePlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("Failed to clone.");
        }
        PiePlotTests.assertTrue((piePlot != piePlot2 ? 1 : 0) != 0);
        PiePlotTests.assertTrue((piePlot.getClass() == piePlot2.getClass() ? 1 : 0) != 0);
        PiePlotTests.assertTrue((boolean)piePlot.equals(piePlot2));
    }

    public void testSerialization() {
        PiePlot piePlot = new PiePlot(null);
        PiePlot piePlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(piePlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            piePlot2 = (PiePlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PiePlotTests.assertEquals((Object)piePlot, piePlot2);
    }
}

