/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CombinedRangeXYPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CombinedRangeXYPlotTests.class);
    }

    public CombinedRangeXYPlotTests(String string) {
        super(string);
    }

    public void testEquals() {
        CombinedRangeXYPlot combinedRangeXYPlot = this.createPlot();
        CombinedRangeXYPlot combinedRangeXYPlot2 = this.createPlot();
        CombinedRangeXYPlotTests.assertTrue((boolean)combinedRangeXYPlot.equals(combinedRangeXYPlot2));
        CombinedRangeXYPlotTests.assertTrue((boolean)combinedRangeXYPlot2.equals(combinedRangeXYPlot));
    }

    public void testRemoveSubplot() {
        CombinedRangeXYPlot combinedRangeXYPlot = new CombinedRangeXYPlot();
        XYPlot xYPlot = new XYPlot();
        XYPlot xYPlot2 = new XYPlot();
        combinedRangeXYPlot.add(xYPlot);
        combinedRangeXYPlot.add(xYPlot2);
        combinedRangeXYPlot.remove(xYPlot2);
        List list = combinedRangeXYPlot.getSubplots();
        CombinedRangeXYPlotTests.assertTrue((list.get(0) == xYPlot ? 1 : 0) != 0);
    }

    public void testCloning() {
        CombinedRangeXYPlot combinedRangeXYPlot = this.createPlot();
        CombinedRangeXYPlot combinedRangeXYPlot2 = null;
        try {
            combinedRangeXYPlot2 = (CombinedRangeXYPlot)combinedRangeXYPlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        CombinedRangeXYPlotTests.assertTrue((combinedRangeXYPlot != combinedRangeXYPlot2 ? 1 : 0) != 0);
        CombinedRangeXYPlotTests.assertTrue((combinedRangeXYPlot.getClass() == combinedRangeXYPlot2.getClass() ? 1 : 0) != 0);
        CombinedRangeXYPlotTests.assertTrue((boolean)combinedRangeXYPlot.equals(combinedRangeXYPlot2));
    }

    public void testSerialization() {
        CombinedRangeXYPlot combinedRangeXYPlot = this.createPlot();
        CombinedRangeXYPlot combinedRangeXYPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(combinedRangeXYPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            combinedRangeXYPlot2 = (CombinedRangeXYPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CombinedRangeXYPlotTests.assertEquals((Object)combinedRangeXYPlot, combinedRangeXYPlot2);
    }

    private XYDataset createDataset1() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(10.0, 12353.3);
        xYSeries.add(20.0, 13734.4);
        xYSeries.add(30.0, 14525.3);
        xYSeries.add(40.0, 13984.3);
        xYSeries.add(50.0, 12999.4);
        xYSeries.add(60.0, 14274.3);
        xYSeries.add(70.0, 15943.5);
        xYSeries.add(80.0, 14845.3);
        xYSeries.add(90.0, 14645.4);
        xYSeries.add(100.0, 16234.6);
        xYSeries.add(110.0, 17232.3);
        xYSeries.add(120.0, 14232.2);
        xYSeries.add(130.0, 13102.2);
        xYSeries.add(140.0, 14230.2);
        xYSeries.add(150.0, 11235.2);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Series 2"));
        xYSeries2.add(10.0, 15000.3);
        xYSeries2.add(20.0, 11000.4);
        xYSeries2.add(30.0, 17000.3);
        xYSeries2.add(40.0, 15000.3);
        xYSeries2.add(50.0, 14000.4);
        xYSeries2.add(60.0, 12000.3);
        xYSeries2.add(70.0, 11000.5);
        xYSeries2.add(80.0, 12000.3);
        xYSeries2.add(90.0, 13000.4);
        xYSeries2.add(100.0, 12000.6);
        xYSeries2.add(110.0, 13000.3);
        xYSeries2.add(120.0, 17000.2);
        xYSeries2.add(130.0, 18000.2);
        xYSeries2.add(140.0, 16000.2);
        xYSeries2.add(150.0, 17000.2);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        return xYSeriesCollection;
    }

    private XYDataset createDataset2() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 3"));
        xYSeries.add(10.0, 16853.2);
        xYSeries.add(20.0, 19642.3);
        xYSeries.add(30.0, 18253.5);
        xYSeries.add(40.0, 15352.3);
        xYSeries.add(50.0, 13532.0);
        xYSeries.add(100.0, 12635.3);
        xYSeries.add(110.0, 13998.2);
        xYSeries.add(120.0, 11943.2);
        xYSeries.add(130.0, 16943.9);
        xYSeries.add(140.0, 17843.2);
        xYSeries.add(150.0, 16495.3);
        xYSeries.add(160.0, 17943.6);
        xYSeries.add(170.0, 18500.7);
        xYSeries.add(180.0, 19595.9);
        return new XYSeriesCollection(xYSeries);
    }

    private CombinedRangeXYPlot createPlot() {
        XYDataset xYDataset = this.createDataset1();
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        NumberAxis numberAxis = new NumberAxis("Range 1");
        XYPlot xYPlot = new XYPlot(xYDataset, null, numberAxis, standardXYItemRenderer);
        xYPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        XYTextAnnotation xYTextAnnotation = new XYTextAnnotation("Hello!", 50.0, 10000.0);
        xYTextAnnotation.setFont(new Font("SansSerif", 0, 9));
        xYTextAnnotation.setRotationAngle(0.7853981633974483);
        xYPlot.addAnnotation(xYTextAnnotation);
        XYDataset xYDataset2 = this.createDataset2();
        StandardXYItemRenderer standardXYItemRenderer2 = new StandardXYItemRenderer();
        NumberAxis numberAxis2 = new NumberAxis("Range 2");
        numberAxis2.setAutoRangeIncludesZero(false);
        XYPlot xYPlot2 = new XYPlot(xYDataset2, null, numberAxis2, standardXYItemRenderer2);
        xYPlot2.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        CombinedRangeXYPlot combinedRangeXYPlot = new CombinedRangeXYPlot(new NumberAxis("Range"));
        combinedRangeXYPlot.setGap(10.0);
        combinedRangeXYPlot.add(xYPlot, 1);
        combinedRangeXYPlot.add(xYPlot2, 1);
        combinedRangeXYPlot.setOrientation(PlotOrientation.VERTICAL);
        return combinedRangeXYPlot;
    }
}

