/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class CombinedDomainCategoryPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CombinedDomainCategoryPlotTests.class);
    }

    public CombinedDomainCategoryPlotTests(String string) {
        super(string);
    }

    public void testRemoveSubplot() {
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = new CombinedDomainCategoryPlot();
        CategoryPlot categoryPlot = new CategoryPlot();
        CategoryPlot categoryPlot2 = new CategoryPlot();
        combinedDomainCategoryPlot.add(categoryPlot);
        combinedDomainCategoryPlot.add(categoryPlot2);
        combinedDomainCategoryPlot.remove(categoryPlot2);
        List list = combinedDomainCategoryPlot.getSubplots();
        CombinedDomainCategoryPlotTests.assertTrue((list.get(0) == categoryPlot ? 1 : 0) != 0);
        CombinedDomainCategoryPlotTests.assertEquals((int)1, (int)list.size());
    }

    public void testEquals() {
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = this.createPlot();
        CombinedDomainCategoryPlot combinedDomainCategoryPlot2 = this.createPlot();
        CombinedDomainCategoryPlotTests.assertTrue((boolean)combinedDomainCategoryPlot.equals(combinedDomainCategoryPlot2));
    }

    public void testCloning() {
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = this.createPlot();
        CombinedDomainCategoryPlot combinedDomainCategoryPlot2 = null;
        try {
            combinedDomainCategoryPlot2 = (CombinedDomainCategoryPlot)combinedDomainCategoryPlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        CombinedDomainCategoryPlotTests.assertTrue((combinedDomainCategoryPlot != combinedDomainCategoryPlot2 ? 1 : 0) != 0);
        CombinedDomainCategoryPlotTests.assertTrue((combinedDomainCategoryPlot.getClass() == combinedDomainCategoryPlot2.getClass() ? 1 : 0) != 0);
        CombinedDomainCategoryPlotTests.assertTrue((boolean)combinedDomainCategoryPlot.equals(combinedDomainCategoryPlot2));
    }

    public void testSerialization() {
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = this.createPlot();
        CombinedDomainCategoryPlot combinedDomainCategoryPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(combinedDomainCategoryPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            combinedDomainCategoryPlot2 = (CombinedDomainCategoryPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CombinedDomainCategoryPlotTests.assertEquals((Object)combinedDomainCategoryPlot, combinedDomainCategoryPlot2);
    }

    public CategoryDataset createDataset1() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        String string = "First";
        String string2 = "Second";
        String string3 = "Type 1";
        String string4 = "Type 2";
        String string5 = "Type 3";
        String string6 = "Type 4";
        String string7 = "Type 5";
        String string8 = "Type 6";
        String string9 = "Type 7";
        String string10 = "Type 8";
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)string), (Comparable)((Object)string3));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)string), (Comparable)((Object)string4));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)string), (Comparable)((Object)string5));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)string), (Comparable)((Object)string6));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)string), (Comparable)((Object)string7));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)string), (Comparable)((Object)string8));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)string), (Comparable)((Object)string9));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)string), (Comparable)((Object)string10));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)string2), (Comparable)((Object)string3));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)string2), (Comparable)((Object)string4));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)string2), (Comparable)((Object)string5));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)string2), (Comparable)((Object)string6));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)string2), (Comparable)((Object)string7));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)string2), (Comparable)((Object)string8));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)string2), (Comparable)((Object)string9));
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)string2), (Comparable)((Object)string10));
        return defaultCategoryDataset;
    }

    public CategoryDataset createDataset2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        String string = "Third";
        String string2 = "Fourth";
        String string3 = "Type 1";
        String string4 = "Type 2";
        String string5 = "Type 3";
        String string6 = "Type 4";
        String string7 = "Type 5";
        String string8 = "Type 6";
        String string9 = "Type 7";
        String string10 = "Type 8";
        defaultCategoryDataset.addValue(11.0, (Comparable)((Object)string), (Comparable)((Object)string3));
        defaultCategoryDataset.addValue(14.0, (Comparable)((Object)string), (Comparable)((Object)string4));
        defaultCategoryDataset.addValue(13.0, (Comparable)((Object)string), (Comparable)((Object)string5));
        defaultCategoryDataset.addValue(15.0, (Comparable)((Object)string), (Comparable)((Object)string6));
        defaultCategoryDataset.addValue(15.0, (Comparable)((Object)string), (Comparable)((Object)string7));
        defaultCategoryDataset.addValue(17.0, (Comparable)((Object)string), (Comparable)((Object)string8));
        defaultCategoryDataset.addValue(17.0, (Comparable)((Object)string), (Comparable)((Object)string9));
        defaultCategoryDataset.addValue(18.0, (Comparable)((Object)string), (Comparable)((Object)string10));
        defaultCategoryDataset.addValue(15.0, (Comparable)((Object)string2), (Comparable)((Object)string3));
        defaultCategoryDataset.addValue(17.0, (Comparable)((Object)string2), (Comparable)((Object)string4));
        defaultCategoryDataset.addValue(16.0, (Comparable)((Object)string2), (Comparable)((Object)string5));
        defaultCategoryDataset.addValue(18.0, (Comparable)((Object)string2), (Comparable)((Object)string6));
        defaultCategoryDataset.addValue(14.0, (Comparable)((Object)string2), (Comparable)((Object)string7));
        defaultCategoryDataset.addValue(14.0, (Comparable)((Object)string2), (Comparable)((Object)string8));
        defaultCategoryDataset.addValue(12.0, (Comparable)((Object)string2), (Comparable)((Object)string9));
        defaultCategoryDataset.addValue(11.0, (Comparable)((Object)string2), (Comparable)((Object)string10));
        return defaultCategoryDataset;
    }

    private CombinedDomainCategoryPlot createPlot() {
        CategoryDataset categoryDataset = this.createDataset1();
        NumberAxis numberAxis = new NumberAxis("Value");
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        lineAndShapeRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, null, numberAxis, lineAndShapeRenderer);
        categoryPlot.setDomainGridlinesVisible(true);
        CategoryDataset categoryDataset2 = this.createDataset2();
        NumberAxis numberAxis2 = new NumberAxis("Value");
        numberAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        CategoryPlot categoryPlot2 = new CategoryPlot(categoryDataset2, null, numberAxis2, barRenderer);
        categoryPlot2.setDomainGridlinesVisible(true);
        CategoryAxis categoryAxis = new CategoryAxis("Category");
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = new CombinedDomainCategoryPlot(categoryAxis);
        combinedDomainCategoryPlot.add(categoryPlot, 2);
        combinedDomainCategoryPlot.add(categoryPlot2, 1);
        return combinedDomainCategoryPlot;
    }
}

