/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class CombinedRangeXYPlot
extends XYPlot
implements Zoomable,
Cloneable,
PublicCloneable,
Serializable,
PlotChangeListener {
    private static final long serialVersionUID = -5177814085082031168L;
    private List subplots = new ArrayList();
    private int totalWeight = 0;
    private double gap = 5.0;
    private transient Rectangle2D[] subplotAreas;

    public CombinedRangeXYPlot() {
        this(new NumberAxis());
    }

    public CombinedRangeXYPlot(ValueAxis valueAxis) {
        super(null, null, valueAxis, null);
    }

    public String getPlotType() {
        return localizationResources.getString("Combined_Range_XYPlot");
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d) {
        this.gap = d;
    }

    public void add(XYPlot xYPlot) {
        this.add(xYPlot, 1);
    }

    public void add(XYPlot xYPlot, int n) {
        if (n <= 0) {
            String string = "The 'weight' must be positive.";
            throw new IllegalArgumentException(string);
        }
        xYPlot.setParent(this);
        xYPlot.setWeight(n);
        xYPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        xYPlot.setRangeAxis(null);
        xYPlot.addChangeListener(this);
        this.subplots.add(xYPlot);
        this.totalWeight += n;
        this.configureRangeAxes();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void remove(XYPlot xYPlot) {
        if (xYPlot == null) {
            throw new IllegalArgumentException(" Null 'subplot' argument.");
        }
        int n = -1;
        int n2 = this.subplots.size();
        for (int i = 0; n == -1 && i < n2; ++i) {
            if (this.subplots.get(i) != xYPlot) continue;
            n = i;
        }
        if (n != -1) {
            xYPlot.setParent(null);
            xYPlot.removeChangeListener(this);
            this.totalWeight -= xYPlot.getWeight();
            this.configureRangeAxes();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public List getSubplots() {
        return Collections.unmodifiableList(this.subplots);
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedRangeAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getRangeAxis();
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((ValueAxis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n = this.subplots.size();
        this.subplotAreas = new Rectangle2D[n];
        double d = ((RectangularShape)cloneable).getX();
        double d2 = ((RectangularShape)cloneable).getY();
        double d3 = 0.0;
        if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n - 1);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n - 1);
        }
        for (int i = 0; i < n; ++i) {
            XYPlot xYPlot = (XYPlot)this.subplots.get(i);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double d4 = d3 * (double)xYPlot.getWeight() / (double)this.totalWeight;
                this.subplotAreas[i] = new Rectangle2D.Double(d, d2, d4, ((RectangularShape)cloneable).getHeight());
                d = d + d4 + this.gap;
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d5 = d3 * (double)xYPlot.getWeight() / (double)this.totalWeight;
                this.subplotAreas[i] = new Rectangle2D.Double(d, d2, ((RectangularShape)cloneable).getWidth(), d5);
                d2 = d2 + d5 + this.gap;
            }
            AxisSpace axisSpace3 = xYPlot.calculateDomainAxisSpace(graphics2D, this.subplotAreas[i], null);
            axisSpace.ensureAtLeast(axisSpace3);
        }
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedDomainAxisSpaceForSubplots(axisSpace);
        ValueAxis valueAxis = this.getRangeAxis();
        RectangleEdge rectangleEdge = this.getRangeAxisEdge();
        double d = RectangleEdge.coordinate(rectangle2D2, rectangleEdge);
        AxisState axisState = valueAxis.draw(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        if (plotState == null) {
            plotState = new PlotState();
        }
        plotState.getSharedAxisStates().put(valueAxis, axisState);
        for (int i = 0; i < this.subplots.size(); ++i) {
            XYPlot xYPlot = (XYPlot)this.subplots.get(i);
            PlotRenderingInfo plotRenderingInfo2 = null;
            if (plotRenderingInfo != null) {
                plotRenderingInfo2 = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo(plotRenderingInfo2);
            }
            xYPlot.draw(graphics2D, this.subplotAreas[i], point2D, plotState, plotRenderingInfo2);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = this.getFixedLegendItems();
        if (legendItemCollection == null) {
            legendItemCollection = new LegendItemCollection();
            if (this.subplots != null) {
                for (XYPlot xYPlot : this.subplots) {
                    LegendItemCollection legendItemCollection2 = xYPlot.getLegendItems();
                    legendItemCollection.addAll(legendItemCollection2);
                }
            }
        }
        return legendItemCollection;
    }

    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        XYPlot xYPlot = this.findSubplot(plotRenderingInfo, point2D);
        if (xYPlot != null) {
            xYPlot.zoomDomainAxes(d, plotRenderingInfo, point2D);
        }
    }

    public void zoomDomainAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        XYPlot xYPlot = this.findSubplot(plotRenderingInfo, point2D);
        if (xYPlot != null) {
            xYPlot.zoomDomainAxes(d, d2, plotRenderingInfo, point2D);
        }
    }

    public XYPlot findSubplot(PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        XYPlot xYPlot = null;
        int n = plotRenderingInfo.getSubplotIndex(point2D);
        if (n >= 0) {
            xYPlot = (XYPlot)this.subplots.get(n);
        }
        return xYPlot;
    }

    public void setRenderer(XYItemRenderer xYItemRenderer) {
        super.setRenderer(xYItemRenderer);
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setRenderer(xYItemRenderer);
        }
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setOrientation(plotOrientation);
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            for (XYPlot xYPlot : this.subplots) {
                range = Range.combine(range, xYPlot.getDataRange(valueAxis));
            }
        }
        return range;
    }

    protected void setFixedDomainAxisSpaceForSubplots(AxisSpace axisSpace) {
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setFixedDomainAxisSpace(axisSpace);
        }
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            for (int i = 0; i < this.subplots.size(); ++i) {
                XYPlot xYPlot = (XYPlot)this.subplots.get(i);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(i);
                xYPlot.handleClick(n, n2, plotRenderingInfo2);
            }
        }
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CombinedRangeXYPlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CombinedRangeXYPlot combinedRangeXYPlot = (CombinedRangeXYPlot)object;
        if (!ObjectUtilities.equal(this.subplots, combinedRangeXYPlot.subplots)) {
            return false;
        }
        if (this.totalWeight != combinedRangeXYPlot.totalWeight) {
            return false;
        }
        return this.gap == combinedRangeXYPlot.gap;
    }

    public Object clone() throws CloneNotSupportedException {
        CombinedRangeXYPlot combinedRangeXYPlot = (CombinedRangeXYPlot)super.clone();
        combinedRangeXYPlot.subplots = (List)ObjectUtilities.deepClone(this.subplots);
        for (Plot plot : combinedRangeXYPlot.subplots) {
            plot.setParent(combinedRangeXYPlot);
        }
        ValueAxis valueAxis = combinedRangeXYPlot.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        return combinedRangeXYPlot;
    }
}

