/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;

public class StandardPieSectionLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardPieSectionLabelGeneratorTests.class);
    }

    public StandardPieSectionLabelGeneratorTests(String string) {
        super(string);
    }

    public void testEquals() {
        StandardPieSectionLabelGenerator standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator();
        StandardPieSectionLabelGenerator standardPieSectionLabelGenerator2 = new StandardPieSectionLabelGenerator();
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)standardPieSectionLabelGenerator.equals(standardPieSectionLabelGenerator2));
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)standardPieSectionLabelGenerator2.equals(standardPieSectionLabelGenerator));
        standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator("{0}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertFalse((boolean)standardPieSectionLabelGenerator.equals(standardPieSectionLabelGenerator2));
        standardPieSectionLabelGenerator2 = new StandardPieSectionLabelGenerator("{0}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)standardPieSectionLabelGenerator.equals(standardPieSectionLabelGenerator2));
        standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertFalse((boolean)standardPieSectionLabelGenerator.equals(standardPieSectionLabelGenerator2));
        standardPieSectionLabelGenerator2 = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)standardPieSectionLabelGenerator.equals(standardPieSectionLabelGenerator2));
        standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertFalse((boolean)standardPieSectionLabelGenerator.equals(standardPieSectionLabelGenerator2));
        standardPieSectionLabelGenerator2 = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), NumberFormat.getPercentInstance());
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)standardPieSectionLabelGenerator.equals(standardPieSectionLabelGenerator2));
        standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), new DecimalFormat("0.000%"));
        StandardPieSectionLabelGeneratorTests.assertFalse((boolean)standardPieSectionLabelGenerator.equals(standardPieSectionLabelGenerator2));
        standardPieSectionLabelGenerator2 = new StandardPieSectionLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), new DecimalFormat("0.000%"));
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)standardPieSectionLabelGenerator.equals(standardPieSectionLabelGenerator2));
    }

    public void testCloning() {
        StandardPieSectionLabelGenerator standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator();
        StandardPieSectionLabelGenerator standardPieSectionLabelGenerator2 = null;
        try {
            standardPieSectionLabelGenerator2 = (StandardPieSectionLabelGenerator)standardPieSectionLabelGenerator.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        StandardPieSectionLabelGeneratorTests.assertTrue((standardPieSectionLabelGenerator != standardPieSectionLabelGenerator2 ? 1 : 0) != 0);
        StandardPieSectionLabelGeneratorTests.assertTrue((standardPieSectionLabelGenerator.getClass() == standardPieSectionLabelGenerator2.getClass() ? 1 : 0) != 0);
        StandardPieSectionLabelGeneratorTests.assertTrue((boolean)standardPieSectionLabelGenerator.equals(standardPieSectionLabelGenerator2));
    }

    public void testSerialization() {
        StandardPieSectionLabelGenerator standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator();
        StandardPieSectionLabelGenerator standardPieSectionLabelGenerator2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(standardPieSectionLabelGenerator);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            standardPieSectionLabelGenerator2 = (StandardPieSectionLabelGenerator)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        StandardPieSectionLabelGeneratorTests.assertEquals((Object)standardPieSectionLabelGenerator, standardPieSectionLabelGenerator2);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)StandardPieSectionLabelGeneratorTests.suite());
    }
}

