/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;

public class StandardPieItemLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardPieItemLabelGeneratorTests.class);
    }

    public StandardPieItemLabelGeneratorTests(String string) {
        super(string);
    }

    public void testEquals() {
        StandardPieItemLabelGenerator standardPieItemLabelGenerator = new StandardPieItemLabelGenerator();
        StandardPieItemLabelGenerator standardPieItemLabelGenerator2 = new StandardPieItemLabelGenerator();
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)standardPieItemLabelGenerator.equals(standardPieItemLabelGenerator2));
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)standardPieItemLabelGenerator2.equals(standardPieItemLabelGenerator));
        standardPieItemLabelGenerator = new StandardPieItemLabelGenerator("{0}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertFalse((boolean)standardPieItemLabelGenerator.equals(standardPieItemLabelGenerator2));
        standardPieItemLabelGenerator2 = new StandardPieItemLabelGenerator("{0}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)standardPieItemLabelGenerator.equals(standardPieItemLabelGenerator2));
        standardPieItemLabelGenerator = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertFalse((boolean)standardPieItemLabelGenerator.equals(standardPieItemLabelGenerator2));
        standardPieItemLabelGenerator2 = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)standardPieItemLabelGenerator.equals(standardPieItemLabelGenerator2));
        standardPieItemLabelGenerator = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertFalse((boolean)standardPieItemLabelGenerator.equals(standardPieItemLabelGenerator2));
        standardPieItemLabelGenerator2 = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)standardPieItemLabelGenerator.equals(standardPieItemLabelGenerator2));
        standardPieItemLabelGenerator = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), new DecimalFormat("0.000%"));
        StandardPieItemLabelGeneratorTests.assertFalse((boolean)standardPieItemLabelGenerator.equals(standardPieItemLabelGenerator2));
        standardPieItemLabelGenerator2 = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), new DecimalFormat("0.000%"));
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)standardPieItemLabelGenerator.equals(standardPieItemLabelGenerator2));
    }

    public void testCloning() {
        StandardPieItemLabelGenerator standardPieItemLabelGenerator = new StandardPieItemLabelGenerator();
        StandardPieItemLabelGenerator standardPieItemLabelGenerator2 = null;
        try {
            standardPieItemLabelGenerator2 = (StandardPieItemLabelGenerator)standardPieItemLabelGenerator.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        StandardPieItemLabelGeneratorTests.assertTrue((standardPieItemLabelGenerator != standardPieItemLabelGenerator2 ? 1 : 0) != 0);
        StandardPieItemLabelGeneratorTests.assertTrue((standardPieItemLabelGenerator.getClass() == standardPieItemLabelGenerator2.getClass() ? 1 : 0) != 0);
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)standardPieItemLabelGenerator.equals(standardPieItemLabelGenerator2));
    }

    public void testSerialization() {
        StandardPieItemLabelGenerator standardPieItemLabelGenerator = new StandardPieItemLabelGenerator();
        StandardPieItemLabelGenerator standardPieItemLabelGenerator2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(standardPieItemLabelGenerator);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            standardPieItemLabelGenerator2 = (StandardPieItemLabelGenerator)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        StandardPieItemLabelGeneratorTests.assertEquals((Object)standardPieItemLabelGenerator, standardPieItemLabelGenerator2);
    }
}

