/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.data.category.DefaultCategoryDataset;

public class StandardCategoryItemLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardCategoryItemLabelGeneratorTests.class);
    }

    public StandardCategoryItemLabelGeneratorTests(String string) {
        super(string);
    }

    public void testGenerateLabel() {
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator("{2}", new DecimalFormat("0.000"));
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C0"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C0"));
        defaultCategoryDataset.addValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        String string = standardCategoryItemLabelGenerator.generateLabel(defaultCategoryDataset, 0, 0);
        StandardCategoryItemLabelGeneratorTests.assertEquals((String)"1.000", (String)string);
        string = standardCategoryItemLabelGenerator.generateLabel(defaultCategoryDataset, 1, 1);
        StandardCategoryItemLabelGeneratorTests.assertEquals((String)"-", (String)string);
    }

    public void testEquals() {
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator();
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator2 = new StandardCategoryItemLabelGenerator();
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)standardCategoryItemLabelGenerator.equals(standardCategoryItemLabelGenerator2));
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)standardCategoryItemLabelGenerator2.equals(standardCategoryItemLabelGenerator));
        standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator("{0}", new DecimalFormat("0.000"));
        StandardCategoryItemLabelGeneratorTests.assertFalse((boolean)standardCategoryItemLabelGenerator.equals(standardCategoryItemLabelGenerator2));
        standardCategoryItemLabelGenerator2 = new StandardCategoryItemLabelGenerator("{0}", new DecimalFormat("0.000"));
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)standardCategoryItemLabelGenerator.equals(standardCategoryItemLabelGenerator2));
        standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator("{1}", new DecimalFormat("0.000"));
        StandardCategoryItemLabelGeneratorTests.assertFalse((boolean)standardCategoryItemLabelGenerator.equals(standardCategoryItemLabelGenerator2));
        standardCategoryItemLabelGenerator2 = new StandardCategoryItemLabelGenerator("{1}", new DecimalFormat("0.000"));
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)standardCategoryItemLabelGenerator.equals(standardCategoryItemLabelGenerator2));
        standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator("{2}", new SimpleDateFormat("d-MMM"));
        StandardCategoryItemLabelGeneratorTests.assertFalse((boolean)standardCategoryItemLabelGenerator.equals(standardCategoryItemLabelGenerator2));
        standardCategoryItemLabelGenerator2 = new StandardCategoryItemLabelGenerator("{2}", new SimpleDateFormat("d-MMM"));
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)standardCategoryItemLabelGenerator.equals(standardCategoryItemLabelGenerator2));
    }

    public void testCloning() {
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator();
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator2 = null;
        try {
            standardCategoryItemLabelGenerator2 = (StandardCategoryItemLabelGenerator)standardCategoryItemLabelGenerator.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        StandardCategoryItemLabelGeneratorTests.assertTrue((standardCategoryItemLabelGenerator != standardCategoryItemLabelGenerator2 ? 1 : 0) != 0);
        StandardCategoryItemLabelGeneratorTests.assertTrue((standardCategoryItemLabelGenerator.getClass() == standardCategoryItemLabelGenerator2.getClass() ? 1 : 0) != 0);
        StandardCategoryItemLabelGeneratorTests.assertTrue((boolean)standardCategoryItemLabelGenerator.equals(standardCategoryItemLabelGenerator2));
    }

    public void testSerialization() {
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator("{2}", DateFormat.getInstance());
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(standardCategoryItemLabelGenerator);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            standardCategoryItemLabelGenerator2 = (StandardCategoryItemLabelGenerator)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        StandardCategoryItemLabelGeneratorTests.assertEquals((Object)standardCategoryItemLabelGenerator, standardCategoryItemLabelGenerator2);
    }
}

