/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.HighLowItemLabelGenerator;

public class HighLowItemLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(HighLowItemLabelGeneratorTests.class);
    }

    public HighLowItemLabelGeneratorTests(String string) {
        super(string);
    }

    public void testEquals() {
        HighLowItemLabelGenerator highLowItemLabelGenerator = new HighLowItemLabelGenerator();
        HighLowItemLabelGenerator highLowItemLabelGenerator2 = new HighLowItemLabelGenerator();
        HighLowItemLabelGeneratorTests.assertTrue((boolean)highLowItemLabelGenerator.equals(highLowItemLabelGenerator2));
        HighLowItemLabelGeneratorTests.assertTrue((boolean)highLowItemLabelGenerator2.equals(highLowItemLabelGenerator));
        highLowItemLabelGenerator = new HighLowItemLabelGenerator(new SimpleDateFormat("d-MMM-yyyy"), NumberFormat.getInstance());
        HighLowItemLabelGeneratorTests.assertFalse((boolean)highLowItemLabelGenerator.equals(highLowItemLabelGenerator2));
        highLowItemLabelGenerator2 = new HighLowItemLabelGenerator(new SimpleDateFormat("d-MMM-yyyy"), NumberFormat.getInstance());
        HighLowItemLabelGeneratorTests.assertTrue((boolean)highLowItemLabelGenerator.equals(highLowItemLabelGenerator2));
        highLowItemLabelGenerator = new HighLowItemLabelGenerator(new SimpleDateFormat("d-MMM-yyyy"), new DecimalFormat("0.000"));
        HighLowItemLabelGeneratorTests.assertFalse((boolean)highLowItemLabelGenerator.equals(highLowItemLabelGenerator2));
        highLowItemLabelGenerator2 = new HighLowItemLabelGenerator(new SimpleDateFormat("d-MMM-yyyy"), new DecimalFormat("0.000"));
        HighLowItemLabelGeneratorTests.assertTrue((boolean)highLowItemLabelGenerator.equals(highLowItemLabelGenerator2));
    }

    public void testCloning() {
        HighLowItemLabelGenerator highLowItemLabelGenerator = new HighLowItemLabelGenerator();
        HighLowItemLabelGenerator highLowItemLabelGenerator2 = null;
        try {
            highLowItemLabelGenerator2 = (HighLowItemLabelGenerator)highLowItemLabelGenerator.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        HighLowItemLabelGeneratorTests.assertTrue((highLowItemLabelGenerator != highLowItemLabelGenerator2 ? 1 : 0) != 0);
        HighLowItemLabelGeneratorTests.assertTrue((highLowItemLabelGenerator.getClass() == highLowItemLabelGenerator2.getClass() ? 1 : 0) != 0);
        HighLowItemLabelGeneratorTests.assertTrue((boolean)highLowItemLabelGenerator.equals(highLowItemLabelGenerator2));
    }

    public void testSerialization() {
        HighLowItemLabelGenerator highLowItemLabelGenerator = new HighLowItemLabelGenerator();
        HighLowItemLabelGenerator highLowItemLabelGenerator2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(highLowItemLabelGenerator);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            highLowItemLabelGenerator2 = (HighLowItemLabelGenerator)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        HighLowItemLabelGeneratorTests.assertEquals((Object)highLowItemLabelGenerator, highLowItemLabelGenerator2);
    }
}

