/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.CustomXYToolTipGenerator;

public class CustomXYItemLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CustomXYItemLabelGeneratorTests.class);
    }

    public CustomXYItemLabelGeneratorTests(String string) {
        super(string);
    }

    public void testCloning() {
        CustomXYToolTipGenerator customXYToolTipGenerator = new CustomXYToolTipGenerator();
        CustomXYToolTipGenerator customXYToolTipGenerator2 = null;
        try {
            customXYToolTipGenerator2 = (CustomXYToolTipGenerator)customXYToolTipGenerator.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        CustomXYItemLabelGeneratorTests.assertTrue((customXYToolTipGenerator != customXYToolTipGenerator2 ? 1 : 0) != 0);
        CustomXYItemLabelGeneratorTests.assertTrue((customXYToolTipGenerator.getClass() == customXYToolTipGenerator2.getClass() ? 1 : 0) != 0);
        CustomXYItemLabelGeneratorTests.assertTrue((boolean)customXYToolTipGenerator.equals(customXYToolTipGenerator2));
    }

    public void testSerialization() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Tooltip A1");
        arrayList.add("Tooltip A2");
        arrayList.add("Tooltip A3");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("Tooltip B1");
        arrayList2.add("Tooltip B2");
        arrayList2.add("Tooltip B3");
        CustomXYToolTipGenerator customXYToolTipGenerator = new CustomXYToolTipGenerator();
        customXYToolTipGenerator.addToolTipSeries(arrayList);
        customXYToolTipGenerator.addToolTipSeries(arrayList2);
        CustomXYToolTipGenerator customXYToolTipGenerator2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(customXYToolTipGenerator);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            customXYToolTipGenerator2 = (CustomXYToolTipGenerator)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        CustomXYItemLabelGeneratorTests.assertEquals((Object)customXYToolTipGenerator, customXYToolTipGenerator2);
    }
}

