/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ObjectUtilities;

public class AbstractXYItemLabelGenerator
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5869744396278660636L;
    private String formatString;
    private NumberFormat xFormat;
    private DateFormat xDateFormat;
    private NumberFormat yFormat;
    private DateFormat yDateFormat;
    private String nullXString = "null";
    private String nullYString = "null";

    protected AbstractXYItemLabelGenerator() {
        this("{2}", NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    protected AbstractXYItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'formatString' argument.");
        }
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'xFormat' argument.");
        }
        if (numberFormat2 == null) {
            throw new IllegalArgumentException("Null 'yFormat' argument.");
        }
        this.formatString = string;
        this.xFormat = numberFormat;
        this.yFormat = numberFormat2;
    }

    protected AbstractXYItemLabelGenerator(String string, DateFormat dateFormat, NumberFormat numberFormat) {
        this(string, NumberFormat.getInstance(), numberFormat);
        this.xDateFormat = dateFormat;
    }

    protected AbstractXYItemLabelGenerator(String string, DateFormat dateFormat, DateFormat dateFormat2) {
        this(string, NumberFormat.getInstance(), NumberFormat.getInstance());
        this.xDateFormat = dateFormat;
        this.yDateFormat = dateFormat2;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public NumberFormat getXFormat() {
        return this.xFormat;
    }

    public DateFormat getXDateFormat() {
        return this.xDateFormat;
    }

    public NumberFormat getYFormat() {
        return this.yFormat;
    }

    public DateFormat getYDateFormat() {
        return this.yDateFormat;
    }

    public String generateLabelString(XYDataset xYDataset, int n, int n2) {
        String string = null;
        Object[] objectArray = this.createItemArray(xYDataset, n, n2);
        string = MessageFormat.format(this.formatString, objectArray);
        return string;
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n, int n2) {
        Object[] objectArray = new Object[3];
        objectArray[0] = xYDataset.getSeriesKey(n).toString();
        double d = xYDataset.getXValue(n, n2);
        objectArray[1] = Double.isNaN(d) && xYDataset.getX(n, n2) == null ? this.nullXString : (this.xDateFormat != null ? this.xDateFormat.format(new Date((long)d)) : this.xFormat.format(d));
        double d2 = xYDataset.getYValue(n, n2);
        objectArray[2] = Double.isNaN(d2) && xYDataset.getY(n, n2) == null ? this.nullYString : (this.yDateFormat != null ? this.yDateFormat.format(new Date((long)d2)) : this.yFormat.format(d2));
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractXYItemLabelGenerator)) {
            return false;
        }
        AbstractXYItemLabelGenerator abstractXYItemLabelGenerator = (AbstractXYItemLabelGenerator)object;
        if (!this.formatString.equals(abstractXYItemLabelGenerator.formatString)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.xFormat, abstractXYItemLabelGenerator.xFormat)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.xDateFormat, abstractXYItemLabelGenerator.xDateFormat)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.yFormat, abstractXYItemLabelGenerator.yFormat)) {
            return false;
        }
        return ObjectUtilities.equal(this.yDateFormat, abstractXYItemLabelGenerator.yDateFormat);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractXYItemLabelGenerator abstractXYItemLabelGenerator = (AbstractXYItemLabelGenerator)super.clone();
        if (this.xFormat != null) {
            abstractXYItemLabelGenerator.xFormat = (NumberFormat)this.xFormat.clone();
        }
        if (this.yFormat != null) {
            abstractXYItemLabelGenerator.yFormat = (NumberFormat)this.yFormat.clone();
        }
        return abstractXYItemLabelGenerator;
    }
}

