/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class XYAreaChartTests
extends TestCase {
    private JFreeChart chart;

    public static Test suite() {
        return new TestSuite(XYAreaChartTests.class);
    }

    public XYAreaChartTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.chart = XYAreaChartTests.createChart();
    }

    public void testDrawWithNullInfo() {
        boolean bl = false;
        try {
            BufferedImage bufferedImage = new BufferedImage(200, 100, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.chart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            graphics2D.dispose();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        XYAreaChartTests.assertTrue((boolean)bl);
    }

    public void testReplaceDataset() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(10.0, 10.0);
        xYSeries.add(20.0, 20.0);
        xYSeries.add(30.0, 30.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        LocalListener localListener = new LocalListener();
        this.chart.addChangeListener(localListener);
        this.chart.getXYPlot().setDataset(xYSeriesCollection);
        XYAreaChartTests.assertEquals((boolean)true, (boolean)localListener.flag);
        ValueAxis valueAxis = this.chart.getXYPlot().getRangeAxis();
        Range range = valueAxis.getRange();
        XYAreaChartTests.assertTrue((String)("Expecting the lower bound of the range to be around 10: " + range.getLowerBound()), (range.getLowerBound() <= 10.0 ? 1 : 0) != 0);
        XYAreaChartTests.assertTrue((String)("Expecting the upper bound of the range to be around 30: " + range.getUpperBound()), (range.getUpperBound() >= 30.0 ? 1 : 0) != 0);
    }

    public void testSetSeriesToolTipGenerator() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        StandardXYToolTipGenerator standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        xYItemRenderer.setSeriesToolTipGenerator(0, standardXYToolTipGenerator);
        XYToolTipGenerator xYToolTipGenerator = xYItemRenderer.getToolTipGenerator(0, 0);
        XYAreaChartTests.assertTrue((xYToolTipGenerator == standardXYToolTipGenerator ? 1 : 0) != 0);
    }

    private static JFreeChart createChart() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 2.0);
        xYSeries.add(3.0, 3.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return ChartFactory.createXYAreaChart("Area Chart", "Domain", "Range", xYSeriesCollection, PlotOrientation.VERTICAL, true, true, true);
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent chartChangeEvent) {
            this.flag = true;
        }
    }
}

