/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;

public class WaterfallChartTests
extends TestCase {
    private JFreeChart chart;

    public static Test suite() {
        return new TestSuite(WaterfallChartTests.class);
    }

    public WaterfallChartTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.chart = WaterfallChartTests.createWaterfallChart();
    }

    public void testDrawWithNullInfo() {
        boolean bl = false;
        try {
            BufferedImage bufferedImage = new BufferedImage(200, 100, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.chart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            graphics2D.dispose();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        WaterfallChartTests.assertTrue((boolean)bl);
    }

    public void testSetSeriesToolTipGenerator() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        categoryItemRenderer.setSeriesToolTipGenerator(0, standardCategoryToolTipGenerator);
        CategoryToolTipGenerator categoryToolTipGenerator = categoryItemRenderer.getToolTipGenerator(0, 0);
        WaterfallChartTests.assertTrue((categoryToolTipGenerator == standardCategoryToolTipGenerator ? 1 : 0) != 0);
    }

    public void testSetSeriesURLGenerator() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        StandardCategoryURLGenerator standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        categoryItemRenderer.setSeriesItemURLGenerator(0, standardCategoryURLGenerator);
        CategoryURLGenerator categoryURLGenerator = categoryItemRenderer.getItemURLGenerator(0, 0);
        WaterfallChartTests.assertTrue((categoryURLGenerator == standardCategoryURLGenerator ? 1 : 0) != 0);
    }

    private static JFreeChart createWaterfallChart() {
        Number[][] numberArray = new Integer[][]{{new Integer(-3), new Integer(-2)}, {new Integer(-1), new Integer(1)}, {new Integer(2), new Integer(3)}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("S", "C", numberArray);
        return ChartFactory.createWaterfallChart("Waterfall Chart", "Domain", "Range", categoryDataset, PlotOrientation.HORIZONTAL, true, true, true);
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent chartChangeEvent) {
            this.flag = true;
        }
    }
}

