/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;

public class PieChartTests
extends TestCase {
    private JFreeChart pieChart;

    public static Test suite() {
        return new TestSuite(PieChartTests.class);
    }

    public PieChartTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.pieChart = PieChartTests.createPieChart();
    }

    public void testReplaceDatasetOnPieChart() {
        LocalListener localListener = new LocalListener();
        this.pieChart.addChangeListener(localListener);
        PiePlot piePlot = (PiePlot)this.pieChart.getPlot();
        piePlot.setDataset(null);
        PieChartTests.assertEquals((boolean)true, (boolean)localListener.flag);
        PieChartTests.assertNull((Object)piePlot.getDataset());
    }

    private static JFreeChart createPieChart() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"Java"), new Double(43.2));
        defaultPieDataset.setValue((Comparable)((Object)"Visual Basic"), new Double(0.0));
        defaultPieDataset.setValue((Comparable)((Object)"C/C++"), new Double(17.5));
        return ChartFactory.createPieChart("Pie Chart", defaultPieDataset, true, true, false);
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent chartChangeEvent) {
            this.flag = true;
        }
    }
}

