/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.TickLabelEntity;

public class TickLabelEntityTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TickLabelEntityTests.class);
    }

    public TickLabelEntityTests(String string) {
        super(string);
    }

    public void testEquals() {
        TickLabelEntity tickLabelEntity = new TickLabelEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL");
        TickLabelEntity tickLabelEntity2 = new TickLabelEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL");
        TickLabelEntityTests.assertTrue((boolean)tickLabelEntity.equals(tickLabelEntity2));
        tickLabelEntity.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        TickLabelEntityTests.assertFalse((boolean)tickLabelEntity.equals(tickLabelEntity2));
        tickLabelEntity2.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        TickLabelEntityTests.assertTrue((boolean)tickLabelEntity.equals(tickLabelEntity2));
        tickLabelEntity.setToolTipText("New ToolTip");
        TickLabelEntityTests.assertFalse((boolean)tickLabelEntity.equals(tickLabelEntity2));
        tickLabelEntity2.setToolTipText("New ToolTip");
        TickLabelEntityTests.assertTrue((boolean)tickLabelEntity.equals(tickLabelEntity2));
        tickLabelEntity.setURLText("New URL");
        TickLabelEntityTests.assertFalse((boolean)tickLabelEntity.equals(tickLabelEntity2));
        tickLabelEntity2.setURLText("New URL");
        TickLabelEntityTests.assertTrue((boolean)tickLabelEntity.equals(tickLabelEntity2));
    }

    public void testCloning() {
        TickLabelEntity tickLabelEntity = new TickLabelEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL");
        TickLabelEntity tickLabelEntity2 = null;
        try {
            tickLabelEntity2 = (TickLabelEntity)tickLabelEntity.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        TickLabelEntityTests.assertTrue((tickLabelEntity != tickLabelEntity2 ? 1 : 0) != 0);
        TickLabelEntityTests.assertTrue((tickLabelEntity.getClass() == tickLabelEntity2.getClass() ? 1 : 0) != 0);
        TickLabelEntityTests.assertTrue((boolean)tickLabelEntity.equals(tickLabelEntity2));
    }

    public void testSerialization() {
        TickLabelEntity tickLabelEntity = new TickLabelEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL");
        TickLabelEntity tickLabelEntity2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(tickLabelEntity);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            tickLabelEntity2 = (TickLabelEntity)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TickLabelEntityTests.assertEquals((Object)tickLabelEntity, tickLabelEntity2);
    }
}

