/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.data.general.DefaultPieDataset;

public class PieSectionEntityTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PieSectionEntityTests.class);
    }

    public PieSectionEntityTests(String string) {
        super(string);
    }

    public void testEquals() {
        PieSectionEntity pieSectionEntity = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 1, 2, (Comparable)((Object)"Key"), "ToolTip", "URL");
        PieSectionEntity pieSectionEntity2 = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 1, 2, (Comparable)((Object)"Key"), "ToolTip", "URL");
        PieSectionEntityTests.assertTrue((boolean)pieSectionEntity.equals(pieSectionEntity2));
        pieSectionEntity.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        PieSectionEntityTests.assertFalse((boolean)pieSectionEntity.equals(pieSectionEntity2));
        pieSectionEntity2.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        PieSectionEntityTests.assertTrue((boolean)pieSectionEntity.equals(pieSectionEntity2));
        pieSectionEntity.setToolTipText("New ToolTip");
        PieSectionEntityTests.assertFalse((boolean)pieSectionEntity.equals(pieSectionEntity2));
        pieSectionEntity2.setToolTipText("New ToolTip");
        PieSectionEntityTests.assertTrue((boolean)pieSectionEntity.equals(pieSectionEntity2));
        pieSectionEntity.setURLText("New URL");
        PieSectionEntityTests.assertFalse((boolean)pieSectionEntity.equals(pieSectionEntity2));
        pieSectionEntity2.setURLText("New URL");
        PieSectionEntityTests.assertTrue((boolean)pieSectionEntity.equals(pieSectionEntity2));
    }

    public void testCloning() {
        PieSectionEntity pieSectionEntity = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 1, 2, (Comparable)((Object)"Key"), "ToolTip", "URL");
        PieSectionEntity pieSectionEntity2 = null;
        try {
            pieSectionEntity2 = (PieSectionEntity)pieSectionEntity.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        PieSectionEntityTests.assertTrue((pieSectionEntity != pieSectionEntity2 ? 1 : 0) != 0);
        PieSectionEntityTests.assertTrue((pieSectionEntity.getClass() == pieSectionEntity2.getClass() ? 1 : 0) != 0);
        PieSectionEntityTests.assertTrue((boolean)pieSectionEntity.equals(pieSectionEntity2));
    }

    public void testSerialization() {
        PieSectionEntity pieSectionEntity = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 1, 2, (Comparable)((Object)"Key"), "ToolTip", "URL");
        PieSectionEntity pieSectionEntity2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(pieSectionEntity);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            pieSectionEntity2 = (PieSectionEntity)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        PieSectionEntityTests.assertEquals((Object)pieSectionEntity, pieSectionEntity2);
    }
}

