/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.LegendItemEntity;

public class LegendItemEntityTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(LegendItemEntityTests.class);
    }

    public LegendItemEntityTests(String string) {
        super(string);
    }

    public void testEquals() {
        LegendItemEntity legendItemEntity = new LegendItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        LegendItemEntity legendItemEntity2 = new LegendItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        LegendItemEntityTests.assertTrue((boolean)legendItemEntity.equals(legendItemEntity2));
        legendItemEntity.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        LegendItemEntityTests.assertFalse((boolean)legendItemEntity.equals(legendItemEntity2));
        legendItemEntity2.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        LegendItemEntityTests.assertTrue((boolean)legendItemEntity.equals(legendItemEntity2));
        legendItemEntity.setToolTipText("New ToolTip");
        LegendItemEntityTests.assertFalse((boolean)legendItemEntity.equals(legendItemEntity2));
        legendItemEntity2.setToolTipText("New ToolTip");
        LegendItemEntityTests.assertTrue((boolean)legendItemEntity.equals(legendItemEntity2));
        legendItemEntity.setURLText("New URL");
        LegendItemEntityTests.assertFalse((boolean)legendItemEntity.equals(legendItemEntity2));
        legendItemEntity2.setURLText("New URL");
        LegendItemEntityTests.assertTrue((boolean)legendItemEntity.equals(legendItemEntity2));
    }

    public void testCloning() {
        LegendItemEntity legendItemEntity = new LegendItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        LegendItemEntity legendItemEntity2 = null;
        try {
            legendItemEntity2 = (LegendItemEntity)legendItemEntity.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        LegendItemEntityTests.assertTrue((legendItemEntity != legendItemEntity2 ? 1 : 0) != 0);
        LegendItemEntityTests.assertTrue((legendItemEntity.getClass() == legendItemEntity2.getClass() ? 1 : 0) != 0);
        LegendItemEntityTests.assertTrue((boolean)legendItemEntity.equals(legendItemEntity2));
    }

    public void testSerialization() {
        LegendItemEntity legendItemEntity = new LegendItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0));
        LegendItemEntity legendItemEntity2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(legendItemEntity);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            legendItemEntity2 = (LegendItemEntity)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        LegendItemEntityTests.assertEquals((Object)legendItemEntity, legendItemEntity2);
    }
}

