/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.ContourEntity;

public class ContourEntityTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ContourEntityTests.class);
    }

    public ContourEntityTests(String string) {
        super(string);
    }

    public void testEquals() {
        ContourEntity contourEntity = new ContourEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL");
        ContourEntity contourEntity2 = new ContourEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL");
        ContourEntityTests.assertTrue((boolean)contourEntity.equals(contourEntity2));
        contourEntity.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        ContourEntityTests.assertFalse((boolean)contourEntity.equals(contourEntity2));
        contourEntity2.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        ContourEntityTests.assertTrue((boolean)contourEntity.equals(contourEntity2));
        contourEntity.setToolTipText("New ToolTip");
        ContourEntityTests.assertFalse((boolean)contourEntity.equals(contourEntity2));
        contourEntity2.setToolTipText("New ToolTip");
        ContourEntityTests.assertTrue((boolean)contourEntity.equals(contourEntity2));
        contourEntity.setURLText("New URL");
        ContourEntityTests.assertFalse((boolean)contourEntity.equals(contourEntity2));
        contourEntity2.setURLText("New URL");
        ContourEntityTests.assertTrue((boolean)contourEntity.equals(contourEntity2));
        contourEntity.setIndex(99);
        ContourEntityTests.assertFalse((boolean)contourEntity.equals(contourEntity2));
        contourEntity2.setIndex(99);
        ContourEntityTests.assertTrue((boolean)contourEntity.equals(contourEntity2));
    }

    public void testCloning() {
        ContourEntity contourEntity = new ContourEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL");
        ContourEntity contourEntity2 = null;
        try {
            contourEntity2 = (ContourEntity)contourEntity.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        ContourEntityTests.assertTrue((contourEntity != contourEntity2 ? 1 : 0) != 0);
        ContourEntityTests.assertTrue((contourEntity.getClass() == contourEntity2.getClass() ? 1 : 0) != 0);
        ContourEntityTests.assertTrue((boolean)contourEntity.equals(contourEntity2));
    }

    public void testSerialization() {
        ContourEntity contourEntity = new ContourEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL");
        ContourEntity contourEntity2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(contourEntity);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            contourEntity2 = (ContourEntity)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        ContourEntityTests.assertEquals((Object)contourEntity, contourEntity2);
    }
}

