/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.data.category.DefaultCategoryDataset;

public class CategoryItemEntityTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryItemEntityTests.class);
    }

    public CategoryItemEntityTests(String string) {
        super(string);
    }

    public void testEquals() {
        CategoryItemEntity categoryItemEntity = new CategoryItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL", new DefaultCategoryDataset(), 1, "Category", 9);
        CategoryItemEntity categoryItemEntity2 = new CategoryItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL", new DefaultCategoryDataset(), 1, "Category", 9);
        CategoryItemEntityTests.assertTrue((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        CategoryItemEntityTests.assertFalse((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity2.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        CategoryItemEntityTests.assertTrue((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity.setToolTipText("New ToolTip");
        CategoryItemEntityTests.assertFalse((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity2.setToolTipText("New ToolTip");
        CategoryItemEntityTests.assertTrue((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity.setURLText("New URL");
        CategoryItemEntityTests.assertFalse((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity2.setURLText("New URL");
        CategoryItemEntityTests.assertTrue((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity.setCategory("Category 20");
        CategoryItemEntityTests.assertFalse((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity2.setCategory("Category 20");
        CategoryItemEntityTests.assertTrue((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity.setCategoryIndex(20);
        CategoryItemEntityTests.assertFalse((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity2.setCategoryIndex(20);
        CategoryItemEntityTests.assertTrue((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity.setSeries(88);
        CategoryItemEntityTests.assertFalse((boolean)categoryItemEntity.equals(categoryItemEntity2));
        categoryItemEntity2.setSeries(88);
        CategoryItemEntityTests.assertTrue((boolean)categoryItemEntity.equals(categoryItemEntity2));
    }

    public void testCloning() {
        CategoryItemEntity categoryItemEntity = new CategoryItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL", new DefaultCategoryDataset(), 1, "Category", 9);
        CategoryItemEntity categoryItemEntity2 = null;
        try {
            categoryItemEntity2 = (CategoryItemEntity)categoryItemEntity.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        CategoryItemEntityTests.assertTrue((categoryItemEntity != categoryItemEntity2 ? 1 : 0) != 0);
        CategoryItemEntityTests.assertTrue((categoryItemEntity.getClass() == categoryItemEntity2.getClass() ? 1 : 0) != 0);
        CategoryItemEntityTests.assertTrue((boolean)categoryItemEntity.equals(categoryItemEntity2));
    }

    public void testSerialization() {
        CategoryItemEntity categoryItemEntity = new CategoryItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), "ToolTip", "URL", new DefaultCategoryDataset(), 1, "Category", 9);
        CategoryItemEntity categoryItemEntity2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(categoryItemEntity);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            categoryItemEntity2 = (CategoryItemEntity)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        CategoryItemEntityTests.assertEquals((Object)categoryItemEntity, categoryItemEntity2);
    }
}

