/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYLogAxesDemo
extends ApplicationFrame {
    public XYLogAxesDemo(String string) {
        super(string);
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Series 2"));
        XYSeries xYSeries3 = new XYSeries((Comparable)((Object)"Series 3"));
        for (int i = 1; i <= 50; ++i) {
            xYSeries.add((double)i, 10.0 * Math.exp((double)i / 5.0));
            xYSeries2.add((double)i, 20.0 * Math.exp((double)i / 5.0));
            xYSeries3.add((double)i, 30.0 * Math.exp((double)i / 5.0));
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        xYSeriesCollection.addSeries(xYSeries3);
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Log Axis Demo", "Category", "Value", xYSeriesCollection, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        NumberAxis numberAxis = new NumberAxis("x");
        LogarithmicAxis logarithmicAxis = new LogarithmicAxis("Log(y)");
        xYPlot.setDomainAxis(numberAxis);
        xYPlot.setRangeAxis(logarithmicAxis);
        jFreeChart.setBackgroundPaint(Color.white);
        xYPlot.setOutlinePaint(Color.black);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        XYLogAxesDemo xYLogAxesDemo = new XYLogAxesDemo("XY Log Axes Demo");
        xYLogAxesDemo.pack();
        RefineryUtilities.centerFrameOnScreen(xYLogAxesDemo);
        xYLogAxesDemo.setVisible(true);
    }
}

