/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYLineAndShapeRendererDemo
extends ApplicationFrame {
    public XYLineAndShapeRendererDemo(String string) {
        super(string);
        XYDataset xYDataset = this.createSampleDataset();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(string, "X", "Y", xYDataset, PlotOrientation.VERTICAL, true, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setSeriesLinesVisible(0, true);
        xYLineAndShapeRenderer.setSeriesShapesVisible(0, false);
        xYLineAndShapeRenderer.setSeriesLinesVisible(1, false);
        xYLineAndShapeRenderer.setSeriesShapesVisible(1, true);
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 300));
        this.setContentPane(chartPanel);
    }

    private XYDataset createSampleDataset() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(1.0, 3.3);
        xYSeries.add(2.0, 4.4);
        xYSeries.add(3.0, 1.7);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Series 2"));
        xYSeries2.add(1.0, 7.3);
        xYSeries2.add(2.0, 6.8);
        xYSeries2.add(3.0, 9.6);
        xYSeries2.add(4.0, 5.6);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        return xYSeriesCollection;
    }

    public static void main(String[] stringArray) {
        XYLineAndShapeRendererDemo xYLineAndShapeRendererDemo = new XYLineAndShapeRendererDemo("XYLineAndShapeRenderer Demo");
        xYLineAndShapeRendererDemo.pack();
        RefineryUtilities.centerFrameOnScreen(xYLineAndShapeRendererDemo);
        xYLineAndShapeRendererDemo.setVisible(true);
    }
}

