/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.WaterfallBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.Layer;
import org.jfree.ui.RefineryUtilities;

public class WaterfallChartDemo2
extends ApplicationFrame {
    public WaterfallChartDemo2(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setEnforceFileExtensions(false);
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(-890.76, (Comparable)((Object)"S1"), (Comparable)((Object)"PY OM"));
        defaultCategoryDataset.addValue(-3021.51, (Comparable)((Object)"S1"), (Comparable)((Object)"Vol CM"));
        defaultCategoryDataset.addValue(-218.32, (Comparable)((Object)"S1"), (Comparable)((Object)"Price"));
        defaultCategoryDataset.addValue(221.75, (Comparable)((Object)"S1"), (Comparable)((Object)"Mat Inf"));
        defaultCategoryDataset.addValue(-1504.1, (Comparable)((Object)"S1"), (Comparable)((Object)"Oth Inf"));
        defaultCategoryDataset.addValue(7103.8, (Comparable)((Object)"S1"), (Comparable)((Object)"VCP"));
        defaultCategoryDataset.addValue(3503.3, (Comparable)((Object)"S1"), (Comparable)((Object)"CM FX"));
        defaultCategoryDataset.addValue(-6561.97, (Comparable)((Object)"S1"), (Comparable)((Object)"Base"));
        defaultCategoryDataset.addValue(-824.25, (Comparable)((Object)"S1"), (Comparable)((Object)"OM"));
        return defaultCategoryDataset;
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        CategoryAxis categoryAxis = new CategoryAxis("Category");
        NumberAxis numberAxis = new NumberAxis("$ in Thousands");
        numberAxis.setLowerMargin(0.1);
        numberAxis.setUpperMargin(0.1);
        DecimalFormat decimalFormat = new DecimalFormat("##,###");
        decimalFormat.setNegativePrefix("(");
        decimalFormat.setNegativeSuffix(")");
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(200.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(500.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(1000.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(2000.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(5000.0, decimalFormat));
        numberAxis.setStandardTickUnits(tickUnits);
        DecimalFormat decimalFormat2 = new DecimalFormat("##,###");
        decimalFormat2.setNegativePrefix("(");
        decimalFormat2.setNegativeSuffix(")");
        WaterfallBarRenderer waterfallBarRenderer = new WaterfallBarRenderer();
        waterfallBarRenderer.setItemLabelsVisible(Boolean.TRUE);
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, waterfallBarRenderer);
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setRangeGridlinePaint(Color.white);
        categoryPlot.setRangeGridlinesVisible(true);
        ValueMarker valueMarker = new ValueMarker(0.0);
        valueMarker.setPaint(Color.blue);
        valueMarker.setStroke(new BasicStroke(1.1f));
        categoryPlot.addRangeMarker(valueMarker, Layer.FOREGROUND);
        JFreeChart jFreeChart = new JFreeChart("OM WaterFall Chart", JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, false);
        jFreeChart.setBackgroundPaint(Color.white);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        WaterfallChartDemo2 waterfallChartDemo2 = new WaterfallChartDemo2("Waterfall Chart Demo 2");
        waterfallChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(waterfallChartDemo2);
        waterfallChartDemo2.setVisible(true);
    }
}

