/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo5
extends ApplicationFrame {
    public TimeSeriesDemo5(String string) {
        super(string);
        XYDataset xYDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private XYDataset createDataset() {
        TimeSeries timeSeries = new TimeSeries("Random Data");
        Day day = new Day(1, 1, 1990);
        double d = 100.0;
        for (int i = 0; i < 4000; ++i) {
            try {
                d = d + Math.random() - 0.5;
                timeSeries.add((RegularTimePeriod)day, new Double(d));
                day = (Day)day.next();
                continue;
            }
            catch (SeriesException seriesException) {
                System.err.println("Error adding to series");
            }
        }
        return new TimeSeriesCollection(timeSeries);
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        return ChartFactory.createTimeSeriesChart("Test", "Day", "Value", xYDataset, false, false, false);
    }

    public static void main(String[] stringArray) {
        TimeSeriesDemo5 timeSeriesDemo5 = new TimeSeriesDemo5("\u20a2\u20a2\u20a2\u20a3\u20a4\u20a5\u20a6\u20a7\u20a8\u20a9\u20aa");
        timeSeriesDemo5.pack();
        RefineryUtilities.positionFrameRandomly(timeSeriesDemo5);
        timeSeriesDemo5.setVisible(true);
    }
}

