/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Font;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StatisticalBarChartDemo
extends ApplicationFrame {
    public StatisticalBarChartDemo(String string) {
        super(string);
        StatisticalCategoryDataset statisticalCategoryDataset = this.createDataset();
        CategoryAxis categoryAxis = new CategoryAxis("Type");
        categoryAxis.setLowerMargin(0.01);
        categoryAxis.setUpperMargin(0.01);
        categoryAxis.setCategoryMargin(0.05);
        NumberAxis numberAxis = new NumberAxis("Value");
        StatisticalBarRenderer statisticalBarRenderer = new StatisticalBarRenderer();
        CategoryPlot categoryPlot = new CategoryPlot(statisticalCategoryDataset, categoryAxis, numberAxis, statisticalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart("Statistical Bar Chart Demo", new Font("Helvetica", 1, 14), categoryPlot, true);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private StatisticalCategoryDataset createDataset() {
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = new DefaultStatisticalCategoryDataset();
        defaultStatisticalCategoryDataset.add(32.5, 17.9, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 1"));
        defaultStatisticalCategoryDataset.add(27.8, 11.4, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 2"));
        defaultStatisticalCategoryDataset.add(29.3, 14.4, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 3"));
        defaultStatisticalCategoryDataset.add(37.9, 10.3, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 4"));
        defaultStatisticalCategoryDataset.add(22.9, 7.9, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 1"));
        defaultStatisticalCategoryDataset.add(21.8, 18.4, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 2"));
        defaultStatisticalCategoryDataset.add(19.3, 12.4, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 3"));
        defaultStatisticalCategoryDataset.add(30.3, 20.7, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 4"));
        defaultStatisticalCategoryDataset.add(12.5, 10.9, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 1"));
        defaultStatisticalCategoryDataset.add(24.8, 7.4, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 2"));
        defaultStatisticalCategoryDataset.add(19.3, 13.4, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 3"));
        defaultStatisticalCategoryDataset.add(17.1, 10.6, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 4"));
        return defaultStatisticalCategoryDataset;
    }

    public static void main(String[] stringArray) {
        StatisticalBarChartDemo statisticalBarChartDemo = new StatisticalBarChartDemo("Statistical Bar Chart Demo");
        statisticalBarChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen(statisticalBarChartDemo);
        statisticalBarChartDemo.setVisible(true);
    }
}

