/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.StandardGradientPaintTransformer;

public class StackedBarChartDemo4
extends ApplicationFrame {
    public StackedBarChartDemo4(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(590, 350));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(20.3, (Comparable)((Object)"Product 1 (US)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(27.2, (Comparable)((Object)"Product 1 (US)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(19.7, (Comparable)((Object)"Product 1 (US)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(19.4, (Comparable)((Object)"Product 1 (Europe)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(10.9, (Comparable)((Object)"Product 1 (Europe)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(18.4, (Comparable)((Object)"Product 1 (Europe)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(16.5, (Comparable)((Object)"Product 1 (Asia)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(15.9, (Comparable)((Object)"Product 1 (Asia)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(16.1, (Comparable)((Object)"Product 1 (Asia)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(13.2, (Comparable)((Object)"Product 1 (Middle East)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(14.4, (Comparable)((Object)"Product 1 (Middle East)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(13.7, (Comparable)((Object)"Product 1 (Middle East)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(23.3, (Comparable)((Object)"Product 2 (US)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(16.2, (Comparable)((Object)"Product 2 (US)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(28.7, (Comparable)((Object)"Product 2 (US)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(12.7, (Comparable)((Object)"Product 2 (Europe)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(17.9, (Comparable)((Object)"Product 2 (Europe)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(12.6, (Comparable)((Object)"Product 2 (Europe)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(15.4, (Comparable)((Object)"Product 2 (Asia)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(21.0, (Comparable)((Object)"Product 2 (Asia)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(11.1, (Comparable)((Object)"Product 2 (Asia)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(23.8, (Comparable)((Object)"Product 2 (Middle East)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(23.4, (Comparable)((Object)"Product 2 (Middle East)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(19.3, (Comparable)((Object)"Product 2 (Middle East)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(11.9, (Comparable)((Object)"Product 3 (US)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(31.0, (Comparable)((Object)"Product 3 (US)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(22.7, (Comparable)((Object)"Product 3 (US)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(15.3, (Comparable)((Object)"Product 3 (Europe)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(14.4, (Comparable)((Object)"Product 3 (Europe)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(25.3, (Comparable)((Object)"Product 3 (Europe)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(23.9, (Comparable)((Object)"Product 3 (Asia)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(19.0, (Comparable)((Object)"Product 3 (Asia)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(10.1, (Comparable)((Object)"Product 3 (Asia)"), (Comparable)((Object)"Mar 04"));
        defaultCategoryDataset.addValue(13.2, (Comparable)((Object)"Product 3 (Middle East)"), (Comparable)((Object)"Jan 04"));
        defaultCategoryDataset.addValue(15.5, (Comparable)((Object)"Product 3 (Middle East)"), (Comparable)((Object)"Feb 04"));
        defaultCategoryDataset.addValue(10.1, (Comparable)((Object)"Product 3 (Middle East)"), (Comparable)((Object)"Mar 04"));
        return defaultCategoryDataset;
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart("Stacked Bar Chart Demo 4", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        GroupedStackedBarRenderer groupedStackedBarRenderer = new GroupedStackedBarRenderer();
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 1 (US)"), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 1 (Europe)"), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 1 (Asia)"), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 1 (Middle East)"), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 2 (US)"), (Comparable)((Object)"G2"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 2 (Europe)"), (Comparable)((Object)"G2"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 2 (Asia)"), (Comparable)((Object)"G2"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 2 (Middle East)"), (Comparable)((Object)"G2"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 3 (US)"), (Comparable)((Object)"G3"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 3 (Europe)"), (Comparable)((Object)"G3"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 3 (Asia)"), (Comparable)((Object)"G3"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"Product 3 (Middle East)"), (Comparable)((Object)"G3"));
        groupedStackedBarRenderer.setSeriesToGroupMap(keyToGroupMap);
        groupedStackedBarRenderer.setItemMargin(0.0);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(34, 34, 255), 0.0f, 0.0f, new Color(136, 136, 255));
        groupedStackedBarRenderer.setSeriesPaint(0, gradientPaint);
        groupedStackedBarRenderer.setSeriesPaint(4, gradientPaint);
        groupedStackedBarRenderer.setSeriesPaint(8, gradientPaint);
        GradientPaint gradientPaint2 = new GradientPaint(0.0f, 0.0f, new Color(34, 255, 34), 0.0f, 0.0f, new Color(136, 255, 136));
        groupedStackedBarRenderer.setSeriesPaint(1, gradientPaint2);
        groupedStackedBarRenderer.setSeriesPaint(5, gradientPaint2);
        groupedStackedBarRenderer.setSeriesPaint(9, gradientPaint2);
        GradientPaint gradientPaint3 = new GradientPaint(0.0f, 0.0f, new Color(255, 34, 34), 0.0f, 0.0f, new Color(255, 136, 136));
        groupedStackedBarRenderer.setSeriesPaint(2, gradientPaint3);
        groupedStackedBarRenderer.setSeriesPaint(6, gradientPaint3);
        groupedStackedBarRenderer.setSeriesPaint(10, gradientPaint3);
        GradientPaint gradientPaint4 = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 34), 0.0f, 0.0f, new Color(255, 255, 136));
        groupedStackedBarRenderer.setSeriesPaint(3, gradientPaint4);
        groupedStackedBarRenderer.setSeriesPaint(7, gradientPaint4);
        groupedStackedBarRenderer.setSeriesPaint(11, gradientPaint4);
        groupedStackedBarRenderer.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL));
        SubCategoryAxis subCategoryAxis = new SubCategoryAxis("Product / Month");
        subCategoryAxis.setCategoryMargin(0.05);
        subCategoryAxis.addSubCategory((Comparable)((Object)"Product 1"));
        subCategoryAxis.addSubCategory((Comparable)((Object)"Product 2"));
        subCategoryAxis.addSubCategory((Comparable)((Object)"Product 3"));
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setDomainAxis(subCategoryAxis);
        categoryPlot.setRenderer(groupedStackedBarRenderer);
        categoryPlot.setFixedLegendItems(this.createLegendItems());
        return jFreeChart;
    }

    private LegendItemCollection createLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        return legendItemCollection;
    }

    public static void main(String[] stringArray) {
        StackedBarChartDemo4 stackedBarChartDemo4 = new StackedBarChartDemo4("Stacked Bar Chart Demo 4");
        stackedBarChartDemo4.pack();
        RefineryUtilities.centerFrameOnScreen(stackedBarChartDemo4);
        stackedBarChartDemo4.setVisible(true);
    }
}

