/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SegmentedTimeline;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class SegmentedHighLowChartDemo
extends ApplicationFrame {
    public SegmentedHighLowChartDemo(String string, boolean bl, int n) {
        super(string);
        Cloneable cloneable;
        System.out.println("\nMaking SegmentedHighLowChartDemo(" + string + ")");
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        SegmentedTimeline segmentedTimeline = null;
        switch (n) {
            case 1: {
                segmentedTimeline = SegmentedTimeline.newMondayThroughFridayTimeline();
                break;
            }
            case 2: {
                segmentedTimeline = SegmentedTimeline.newFifteenMinuteTimeline();
                cloneable = (Calendar)calendar.clone();
                ((Calendar)cloneable).add(1, 1);
                segmentedTimeline.addBaseTimelineExclusions(calendar.getTime().getTime(), ((Calendar)cloneable).getTime().getTime());
                break;
            }
            default: {
                System.out.println("Invalid timelineType.");
                System.exit(1);
            }
        }
        cloneable = DemoDatasetFactory.createSegmentedHighLowDataset(segmentedTimeline, calendar.getTime());
        JFreeChart jFreeChart = bl ? ChartFactory.createHighLowChart(string, "Time", "Value", (OHLCDataset)((Object)cloneable), segmentedTimeline, true) : ChartFactory.createHighLowChart(string, "Time", "Value", (OHLCDataset)((Object)cloneable), true);
        DateAxis dateAxis = (DateAxis)jFreeChart.getXYPlot().getDomainAxis();
        dateAxis.setAutoRange(true);
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new DateTickUnit(2, 1, 3, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(2, 2, 3, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(2, 7, 2, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(2, 15, 2, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(2, 30, 2, 1, new SimpleDateFormat("d-MMM")));
        dateAxis.setStandardTickUnits(tickUnits);
        NumberAxis numberAxis = (NumberAxis)jFreeChart.getXYPlot().getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        ApplicationFrame[][] applicationFrameArray = new ApplicationFrame[2][2];
        applicationFrameArray[0][0] = new SegmentedHighLowChartDemo("Segmented Daily High-Low-Open-Close Demo", true, 1);
        applicationFrameArray[1][0] = new SegmentedHighLowChartDemo("Normal Daily High-Low-Open-Close Demo", false, 1);
        applicationFrameArray[0][1] = new SegmentedHighLowChartDemo("Segmented Intraday High-Low-Open-Close Demo", true, 2);
        applicationFrameArray[1][1] = new SegmentedHighLowChartDemo("Normal Intraday High-Low-Open-Close Demo", false, 2);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                applicationFrameArray[i][j].pack();
                RefineryUtilities.positionFrameOnScreen(applicationFrameArray[i][j], 0.15 + 0.7 * (double)j, 0.25 + 0.5 * (double)i);
                applicationFrameArray[i][j].setVisible(true);
            }
        }
    }
}

