/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.demo.SampleXYDataset2;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ScatterPlotDemo3
extends ApplicationFrame
implements ChartMouseListener {
    private ChartPanel chartPanel;

    public ScatterPlotDemo3(String string) {
        super(string);
        SampleXYDataset2 sampleXYDataset2 = new SampleXYDataset2();
        JFreeChart jFreeChart = this.createChart(sampleXYDataset2);
        this.chartPanel = new ChartPanel(jFreeChart);
        this.chartPanel.addChartMouseListener(this);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        this.chartPanel.setVerticalAxisTrace(true);
        this.chartPanel.setHorizontalAxisTrace(true);
        this.setContentPane(this.chartPanel);
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot("Scatter Plot Demo", "X", "Y", xYDataset, PlotOrientation.VERTICAL, true, true, false);
        NumberAxis numberAxis = (NumberAxis)jFreeChart.getXYPlot().getDomainAxis();
        return jFreeChart;
    }

    public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
        int n = chartMouseEvent.getTrigger().getX();
        int n2 = chartMouseEvent.getTrigger().getY();
        Point2D point2D = this.chartPanel.translateScreenToJava2D(new Point(n, n2));
        XYPlot xYPlot = this.chartPanel.getChart().getXYPlot();
        Rectangle2D rectangle2D = this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        double d = xYPlot.getDomainAxis().java2DToValue(point2D.getX(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d2 = xYPlot.getRangeAxis().java2DToValue(point2D.getY(), rectangle2D, xYPlot.getRangeAxisEdge());
        double d3 = xYPlot.getDomainAxis().valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = xYPlot.getRangeAxis().valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        Point point = this.chartPanel.translateJava2DToScreen(new Point2D.Double(d3, d4));
        System.out.println("Mouse coordinates are (" + n + ", " + n2 + "), in data space = (" + d + ", " + d2 + ").");
        System.out.println("--> (" + ((Point2D)point).getX() + ", " + ((Point2D)point).getY() + ")");
    }

    public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
    }

    public static void main(String[] stringArray) {
        ScatterPlotDemo3 scatterPlotDemo3 = new ScatterPlotDemo3("Scatter Plot Demo 3");
        scatterPlotDemo3.pack();
        RefineryUtilities.centerFrameOnScreen(scatterPlotDemo3);
        scatterPlotDemo3.setVisible(true);
    }
}

