/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Rotation;

public class PieChart3DDemo4
extends ApplicationFrame {
    public PieChart3DDemo4(String string) {
        super(string);
        PieDataset pieDataset = this.createSampleDataset();
        JFreeChart jFreeChart = this.createChart(pieDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private PieDataset createSampleDataset() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"Java"), new Double(43.2));
        defaultPieDataset.setValue((Comparable)((Object)"Visual Basic"), new Double(10.0));
        defaultPieDataset.setValue((Comparable)((Object)"C/C++"), new Double(17.5));
        defaultPieDataset.setValue((Comparable)((Object)"PHP"), new Double(32.5));
        defaultPieDataset.setValue((Comparable)((Object)"Perl"), new Double(1.0));
        return defaultPieDataset;
    }

    private JFreeChart createChart(PieDataset pieDataset) {
        JFreeChart jFreeChart = ChartFactory.createPieChart3D("Pie Chart 3D Demo 4", pieDataset, true, true, false);
        PiePlot3D piePlot3D = (PiePlot3D)jFreeChart.getPlot();
        piePlot3D.setStartAngle(290.0);
        piePlot3D.setDirection(Rotation.CLOCKWISE);
        piePlot3D.setForegroundAlpha(0.5f);
        piePlot3D.setNoDataMessage("No data to display");
        piePlot3D.setLabelGenerator(new CustomLabelGenerator());
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        PieChart3DDemo4 pieChart3DDemo4 = new PieChart3DDemo4("Pie Chart 3D Demo 4");
        pieChart3DDemo4.pack();
        RefineryUtilities.centerFrameOnScreen(pieChart3DDemo4);
        pieChart3DDemo4.setVisible(true);
    }

    static class CustomLabelGenerator
    implements PieSectionLabelGenerator {
        CustomLabelGenerator() {
        }

        public String generateSectionLabel(PieDataset pieDataset, Comparable comparable) {
            String string = null;
            if (pieDataset != null && !comparable.equals("PHP")) {
                string = comparable.toString();
            }
            return string;
        }
    }
}

