/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class PanScrollZoomDemo
extends JFrame
implements ActionListener,
ChangeListener,
ChartChangeListener,
MouseListener {
    private ChartPanel chartPanel;
    private double scrollFactor = 1000.0;
    private JScrollBar scrollBar;
    private Point2D panStartPoint;
    private double[] primYMinMax = new double[2];
    private double[] secondYMinMax = new double[2];
    private static final String ACTION_CMD_PAN = "pan";
    private static final String ACTION_CMD_ZOOM_BOX = "zoomBox";
    private static final String ACTION_CMD_ZOOM_TO_FIT = "zoomFit";
    private static final String ACTION_CMD_ZOOM_IN = "zoomIn";
    private static final String ACTION_CMD_ZOOM_OUT = "zoomOut";
    private static final double ZOOM_FACTOR = 0.8;
    private JToolBar toolBar = this.createToolbar();
    private AbstractButton zoomButton;
    private AbstractButton panButton;
    private AbstractButton zoomInButton;
    private AbstractButton zoomOutButton;
    private AbstractButton fitButton;

    public PanScrollZoomDemo(String string) {
        super(string);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "South");
        JFreeChart jFreeChart = this.createChart();
        this.scrollBar.setModel(new DefaultBoundedRangeModel());
        this.recalcScrollBar(jFreeChart.getPlot());
        this.chartPanel = new ChartPanel(jFreeChart){

            public void autoRangeBoth() {
                System.out.println("Use 'Fit all' button");
            }
        };
        jFreeChart.addChangeListener(this);
        this.actionPerformed(new ActionEvent(this, 0, ACTION_CMD_ZOOM_BOX));
        this.chartPanel.addMouseListener(this);
        this.chartPanel.setPopupMenu(null);
        this.getContentPane().add(this.chartPanel);
    }

    private JFreeChart createChart() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Left 1"));
        xYSeries.add(1.0, 2.0);
        xYSeries.add(2.8, 5.9);
        xYSeries.add(3.0, (Number)null);
        xYSeries.add(3.4, 2.0);
        xYSeries.add(5.0, -1.0);
        xYSeries.add(7.0, 1.0);
        xYSeriesCollection.addSeries(xYSeries);
        XYSeriesCollection xYSeriesCollection2 = new XYSeriesCollection();
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Right 1"));
        xYSeries2.add(3.5, 2.2);
        xYSeries2.add(1.2, 1.3);
        xYSeries2.add(5.7, 4.1);
        xYSeries2.add(7.5, 7.4);
        xYSeriesCollection2.addSeries(xYSeries2);
        NumberAxis numberAxis = new NumberAxis("X");
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setAutoRangeStickyZero(false);
        NumberAxis numberAxis2 = new NumberAxis("Y1");
        numberAxis2.setAutoRangeIncludesZero(false);
        numberAxis2.setAutoRangeStickyZero(false);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(2);
        standardXYItemRenderer.setSeriesPaint(0, Color.blue);
        standardXYItemRenderer.setToolTipGenerator(new StandardXYToolTipGenerator());
        XYPlot xYPlot = new XYPlot(xYSeriesCollection, numberAxis, numberAxis2, standardXYItemRenderer);
        NumberAxis numberAxis3 = new NumberAxis("Y2");
        numberAxis3.setAutoRangeIncludesZero(false);
        numberAxis3.setAutoRangeStickyZero(false);
        xYPlot.setRangeAxis(1, numberAxis3);
        xYPlot.setDataset(1, xYSeriesCollection2);
        xYPlot.mapDatasetToRangeAxis(1, 1);
        xYPlot.mapDatasetToDomainAxis(1, 1);
        StandardXYItemRenderer standardXYItemRenderer2 = new StandardXYItemRenderer(3);
        standardXYItemRenderer2.setToolTipGenerator(new StandardXYToolTipGenerator());
        xYPlot.setRenderer(1, standardXYItemRenderer2);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        this.primYMinMax[0] = -5.0;
        this.primYMinMax[1] = 15.0;
        valueAxis.setLowerBound(this.primYMinMax[0]);
        valueAxis.setUpperBound(this.primYMinMax[1]);
        valueAxis = xYPlot.getRangeAxis(1);
        this.secondYMinMax[0] = -1.0;
        this.secondYMinMax[1] = 10.0;
        valueAxis.setLowerBound(this.secondYMinMax[0]);
        valueAxis.setUpperBound(this.secondYMinMax[1]);
        JFreeChart jFreeChart = new JFreeChart("To pan in zoom mode hold right mouse pressed", null, xYPlot, true);
        TextTitle textTitle = new TextTitle("(but you can only pan if the chart was zoomed before)");
        jFreeChart.addSubtitle(textTitle);
        return jFreeChart;
    }

    private JToolBar createToolbar() {
        JToolBar jToolBar = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.panButton = new JToggleButton();
        this.prepareButton(this.panButton, ACTION_CMD_PAN, " Pan ", "Pan mode");
        buttonGroup.add(this.panButton);
        jToolBar.add(this.panButton);
        this.zoomButton = new JToggleButton();
        this.prepareButton(this.zoomButton, ACTION_CMD_ZOOM_BOX, " Zoom ", "Zoom mode");
        buttonGroup.add(this.zoomButton);
        this.zoomButton.setSelected(true);
        jToolBar.add(this.zoomButton);
        jToolBar.addSeparator();
        this.zoomInButton = new JButton();
        this.prepareButton(this.zoomInButton, ACTION_CMD_ZOOM_IN, " + ", "Zoom in");
        jToolBar.add(this.zoomInButton);
        this.zoomOutButton = new JButton();
        this.prepareButton(this.zoomOutButton, ACTION_CMD_ZOOM_OUT, " - ", "Zoom out");
        jToolBar.add(this.zoomOutButton);
        this.fitButton = new JButton();
        this.prepareButton(this.fitButton, ACTION_CMD_ZOOM_TO_FIT, " Fit ", "Fit all");
        jToolBar.add(this.fitButton);
        jToolBar.addSeparator();
        this.scrollBar = new JScrollBar(0);
        this.scrollBar.setModel(new DefaultBoundedRangeModel());
        jToolBar.add(this.scrollBar);
        this.zoomOutButton.setEnabled(false);
        this.fitButton.setEnabled(false);
        this.scrollBar.setEnabled(false);
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    private void prepareButton(AbstractButton abstractButton, String string, String string2, String string3) {
        abstractButton.setActionCommand(string);
        abstractButton.setText(string2);
        abstractButton.setToolTipText(string3);
        abstractButton.addActionListener(this);
    }

    private void setPanMode(boolean bl) {
        if (bl) {
            this.chartPanel.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.chartPanel.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Plot plot;
            String string = actionEvent.getActionCommand();
            if (string.equals(ACTION_CMD_ZOOM_BOX)) {
                this.setPanMode(false);
            } else if (string.equals(ACTION_CMD_PAN)) {
                this.setPanMode(true);
            } else if (string.equals(ACTION_CMD_ZOOM_IN)) {
                ChartRenderingInfo chartRenderingInfo = this.chartPanel.getChartRenderingInfo();
                Rectangle2D rectangle2D = chartRenderingInfo.getPlotInfo().getDataArea();
                this.zoomBoth(rectangle2D.getCenterX(), rectangle2D.getCenterY(), 0.8);
            } else if (string.equals(ACTION_CMD_ZOOM_OUT)) {
                ChartRenderingInfo chartRenderingInfo = this.chartPanel.getChartRenderingInfo();
                Rectangle2D rectangle2D = chartRenderingInfo.getPlotInfo().getDataArea();
                this.zoomBoth(rectangle2D.getCenterX(), rectangle2D.getCenterY(), 1.25);
            } else if (string.equals(ACTION_CMD_ZOOM_TO_FIT) && (plot = this.chartPanel.getChart().getPlot()) instanceof ValueAxisPlot) {
                XYPlot xYPlot;
                XYPlot xYPlot2 = (XYPlot)plot;
                ValueAxis valueAxis = xYPlot2.getRangeAxis();
                if (valueAxis != null) {
                    valueAxis.setLowerBound(this.primYMinMax[0]);
                    valueAxis.setUpperBound(this.primYMinMax[1]);
                }
                if (plot instanceof XYPlot && (valueAxis = (xYPlot = (XYPlot)plot).getRangeAxis(1)) != null) {
                    valueAxis.setLowerBound(this.secondYMinMax[0]);
                    valueAxis.setUpperBound(this.secondYMinMax[1]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            Object object = changeEvent.getSource();
            BoundedRangeModel boundedRangeModel = this.scrollBar.getModel();
            if (object == boundedRangeModel) {
                int n = boundedRangeModel.getValue();
                int n2 = boundedRangeModel.getExtent();
                Plot plot = this.chartPanel.getChart().getPlot();
                if (plot instanceof XYPlot) {
                    XYPlot xYPlot = (XYPlot)plot;
                    ValueAxis valueAxis = xYPlot.getDomainAxis();
                    this.chartPanel.getChart().removeChangeListener(this);
                    valueAxis.setRange((double)n / this.scrollFactor, (double)(n + n2) / this.scrollFactor);
                    this.chartPanel.getChart().addChangeListener(this);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        try {
            Serializable serializable;
            ValueAxis valueAxis;
            XYPlot xYPlot;
            if (chartChangeEvent.getChart() == null) {
                return;
            }
            BoundedRangeModel boundedRangeModel = this.scrollBar.getModel();
            if (boundedRangeModel == null) {
                return;
            }
            boolean bl = false;
            Plot plot = chartChangeEvent.getChart().getPlot();
            if (plot instanceof XYPlot) {
                xYPlot = (XYPlot)plot;
                valueAxis = xYPlot.getDomainAxis();
                serializable = valueAxis.getRange();
                boundedRangeModel.removeChangeListener(this);
                int n = (int)(((Range)serializable).getLowerBound() * this.scrollFactor);
                boundedRangeModel.setValue(n);
                int n2 = (int)(((Range)serializable).getUpperBound() * this.scrollFactor - (double)n);
                boundedRangeModel.setExtent(n2);
                boundedRangeModel.addChangeListener(this);
                Range range = xYPlot.getDataRange(valueAxis);
                double d = range == null ? 0.0 : range.getLength();
                bl |= ((Range)serializable).getLength() < d;
            }
            if (!bl && plot instanceof XYPlot && (valueAxis = (xYPlot = (XYPlot)plot).getRangeAxis()) != null) {
                boolean bl2 = bl = valueAxis.getLowerBound() > this.primYMinMax[0] || valueAxis.getUpperBound() < this.primYMinMax[1];
                if (!bl && plot instanceof XYPlot && (valueAxis = ((XYPlot)(serializable = (XYPlot)plot)).getRangeAxis(1)) != null) {
                    bl = valueAxis.getLowerBound() > this.secondYMinMax[0] || valueAxis.getUpperBound() < this.secondYMinMax[1];
                }
            }
            this.panButton.setEnabled(bl);
            this.zoomOutButton.setEnabled(bl);
            this.fitButton.setEnabled(bl);
            this.scrollBar.setEnabled(bl);
            if (!bl) {
                this.setPanMode(false);
                this.zoomButton.setSelected(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mousePressed(MouseEvent mouseEvent) {
        try {
            if (!this.panButton.isSelected() && this.panButton.isEnabled() && !SwingUtilities.isRightMouseButton(mouseEvent)) return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            this.panStartPoint = null;
            if (!this.panButton.isSelected()) {
                this.setPanMode(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = WindowsLookAndFeel.class.getName();
            UIManager.setLookAndFeel((String)object);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        object = new PanScrollZoomDemo("Pan & Scroll & Zoom - Demo");
        ((Window)object).pack();
        ((Window)object).setVisible(true);
    }

    private void recalcScrollBar(Plot plot) {
        if (plot instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            valueAxis.setLowerMargin(0.0);
            valueAxis.setUpperMargin(0.0);
            Range range = valueAxis.getRange();
            BoundedRangeModel boundedRangeModel = this.scrollBar.getModel();
            int n = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            if (range.getLength() > 0.0) {
                this.scrollFactor = (double)n / range.getLength();
            }
            double d = range.getLowerBound();
            int n2 = (int)(d * this.scrollFactor);
            boundedRangeModel.setMinimum(n2);
            int n3 = n2;
            boundedRangeModel.setValue(n3);
            double d2 = range.getUpperBound();
            int n4 = (int)(d2 * this.scrollFactor);
            boundedRangeModel.setMaximum(n4);
            int n5 = n4 - n2;
            boundedRangeModel.setExtent(n5);
            boundedRangeModel.addChangeListener(this);
        }
    }

    private void zoomBoth(double d, double d2, double d3) {
        this.zoomHorizontal(d, d3);
        this.zoomVertical(d2, d3);
    }

    private void zoomHorizontal(double d, double d2) {
        XYPlot xYPlot;
        ValueAxis valueAxis;
        JFreeChart jFreeChart = this.chartPanel.getChart();
        ChartRenderingInfo chartRenderingInfo = this.chartPanel.getChartRenderingInfo();
        if (jFreeChart.getPlot() instanceof XYPlot && (valueAxis = (xYPlot = (XYPlot)jFreeChart.getPlot()).getDomainAxis()) != null) {
            double d3 = valueAxis.java2DToValue((float)d, chartRenderingInfo.getPlotInfo().getDataArea(), xYPlot.getDomainAxisEdge());
            if (d2 < 1.0) {
                valueAxis.resizeRange(d2, d3);
            } else if (d2 > 1.0) {
                Range range = xYPlot.getDataRange(valueAxis);
                this.adjustRange(valueAxis, range, d2, d3);
            }
        }
    }

    private void zoomVertical(double d, double d2) {
        JFreeChart jFreeChart = this.chartPanel.getChart();
        ChartRenderingInfo chartRenderingInfo = this.chartPanel.getChartRenderingInfo();
        if (jFreeChart.getPlot() instanceof XYPlot) {
            XYPlot xYPlot;
            ValueAxis valueAxis;
            XYPlot xYPlot2 = (XYPlot)jFreeChart.getPlot();
            ValueAxis valueAxis2 = xYPlot2.getRangeAxis();
            if (valueAxis2 != null) {
                double d3 = valueAxis2.java2DToValue((float)d, chartRenderingInfo.getPlotInfo().getDataArea(), xYPlot2.getRangeAxisEdge());
                if (d2 < 1.0) {
                    valueAxis2.resizeRange(d2, d3);
                } else if (d2 > 1.0) {
                    Range range = new Range(this.primYMinMax[0], this.primYMinMax[1]);
                    this.adjustRange(valueAxis2, range, d2, d3);
                }
            }
            if (jFreeChart.getPlot() instanceof XYPlot && (valueAxis = (xYPlot = (XYPlot)jFreeChart.getPlot()).getRangeAxis(1)) != null) {
                double d4 = valueAxis.java2DToValue((float)d, chartRenderingInfo.getPlotInfo().getDataArea(), xYPlot.getRangeAxisEdge(1));
                if (d2 < 1.0) {
                    valueAxis.resizeRange(d2, d4);
                } else if (d2 > 1.0) {
                    Range range = new Range(this.secondYMinMax[0], this.secondYMinMax[1]);
                    this.adjustRange(valueAxis, range, d2, d4);
                }
            }
        }
    }

    private void adjustRange(ValueAxis valueAxis, Range range, double d, double d2) {
        if (valueAxis == null || range == null) {
            return;
        }
        double d3 = range.getLowerBound() - range.getLength() * valueAxis.getLowerMargin();
        double d4 = range.getUpperBound() + range.getLength() * valueAxis.getUpperMargin();
        double d5 = valueAxis.getRange().getLength() * d / 2.0;
        double d6 = d2 - d5;
        double d7 = d2 + d5;
        double d8 = d6;
        if (d6 < d3) {
            d8 = d3;
            d7 += d3 - d6;
        }
        double d9 = d7;
        if (d7 > d4) {
            d9 = d4;
            d8 = Math.max(d6 -= d7 - d4, d3);
        }
        Range range2 = new Range(d8, d9);
        valueAxis.setRange(range2);
    }
}

