/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.SampleXYDataset;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Log;
import org.jfree.util.PrintStreamLogTarget;

public class MouseZoomDemo
extends ApplicationFrame {
    private ChartPanel chartPanel;
    private JCheckBox xzoom;
    private JCheckBox yzoom;

    public MouseZoomDemo(String string) {
        super(string);
        SampleXYDataset sampleXYDataset = new SampleXYDataset();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Mouse Zoom Demo", "X", "Y", sampleXYDataset, PlotOrientation.VERTICAL, true, true, false);
        this.chartPanel = new ChartPanel(jFreeChart);
        this.chartPanel.setHorizontalAxisTrace(false);
        this.chartPanel.setVerticalAxisTrace(false);
        this.chartPanel.setFillZoomRectangle(true);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.xzoom = new JCheckBox("Horizontal Mouse Zooming");
        this.xzoom.setSelected(false);
        this.yzoom = new JCheckBox("Vertical Mouse Zooming");
        this.yzoom.setSelected(false);
        CheckListener checkListener = new CheckListener();
        this.xzoom.addItemListener(checkListener);
        this.yzoom.addItemListener(checkListener);
        jPanel2.add(this.xzoom);
        jPanel2.add(this.yzoom);
        jPanel.add((Component)jPanel2, "South");
        jPanel.add(this.chartPanel);
        this.setContentPane(jPanel);
    }

    public static void main(String[] stringArray) {
        Log.getInstance().addTarget(new PrintStreamLogTarget(System.out));
        MouseZoomDemo mouseZoomDemo = new MouseZoomDemo("Mouse Zoom Demo");
        mouseZoomDemo.pack();
        RefineryUtilities.centerFrameOnScreen(mouseZoomDemo);
        mouseZoomDemo.setVisible(true);
    }

    class CheckListener
    implements ItemListener {
        CheckListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == MouseZoomDemo.this.xzoom) {
                if (itemEvent.getStateChange() == 2) {
                    MouseZoomDemo.this.chartPanel.setHorizontalAxisTrace(false);
                    MouseZoomDemo.this.chartPanel.repaint();
                } else {
                    MouseZoomDemo.this.chartPanel.setHorizontalAxisTrace(true);
                }
            } else if (itemSelectable == MouseZoomDemo.this.yzoom) {
                if (itemEvent.getStateChange() == 2) {
                    MouseZoomDemo.this.chartPanel.setVerticalAxisTrace(false);
                    MouseZoomDemo.this.chartPanel.repaint();
                } else {
                    MouseZoomDemo.this.chartPanel.setVerticalAxisTrace(true);
                }
            }
        }
    }
}

