/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class LineChartDemo5
extends ApplicationFrame {
    public LineChartDemo5(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 1"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 2"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 3"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 4"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 5"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 6"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 7"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 8"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 1"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 2"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 3"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 4"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 5"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 6"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 7"));
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 8"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 1"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 2"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 3"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 4"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 5"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 6"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 7"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Type 8"));
        return defaultCategoryDataset;
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createLineChart("Line Chart Demo 5", "Type", "Value", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        Shape[] shapeArray = new Shape[3];
        int[] nArray = new int[]{-3, 3, -3};
        int[] nArray2 = new int[]{-3, 0, 3};
        shapeArray[0] = new Polygon(nArray, nArray2, 3);
        shapeArray[1] = new Rectangle2D.Double(-2.0, -3.0, 3.0, 6.0);
        nArray = new int[]{-3, 3, 3};
        nArray2 = new int[]{0, -3, 3};
        shapeArray[2] = new Polygon(nArray, nArray2, 3);
        DefaultDrawingSupplier defaultDrawingSupplier = new DefaultDrawingSupplier(DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, shapeArray);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setDrawingSupplier(defaultDrawingSupplier);
        jFreeChart.setBackgroundPaint(Color.yellow);
        categoryPlot.getRenderer().setSeriesStroke(0, new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{10.0f, 6.0f}, 0.0f));
        categoryPlot.getRenderer().setSeriesStroke(1, new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{6.0f, 6.0f}, 0.0f));
        categoryPlot.getRenderer().setSeriesStroke(2, new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineAndShapeRenderer.setItemLabelsVisible(true);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setUpperMargin(0.12);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        LineChartDemo5 lineChartDemo5 = new LineChartDemo5("Line Chart Demo 5");
        lineChartDemo5.pack();
        RefineryUtilities.centerFrameOnScreen(lineChartDemo5);
        lineChartDemo5.setVisible(true);
    }
}

