/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ImageMapDemo3 {
    public static void main(String[] stringArray) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Curve data"));
        ArrayList<String> arrayList = new ArrayList<String>();
        xYSeries.add((double)simpleDateFormat.parse("01-Jul-2002").getTime(), 5.22);
        arrayList.add("1D - 5.22");
        xYSeries.add((double)simpleDateFormat.parse("02-Jul-2002").getTime(), 5.18);
        arrayList.add("2D - 5.18");
        xYSeries.add((double)simpleDateFormat.parse("03-Jul-2002").getTime(), 5.23);
        arrayList.add("3D - 5.23");
        xYSeries.add((double)simpleDateFormat.parse("04-Jul-2002").getTime(), 5.15);
        arrayList.add("4D - 5.15");
        xYSeries.add((double)simpleDateFormat.parse("05-Jul-2002").getTime(), 5.22);
        arrayList.add("5D - 5.22");
        xYSeries.add((double)simpleDateFormat.parse("06-Jul-2002").getTime(), 5.25);
        arrayList.add("6D - 5.25");
        xYSeries.add((double)simpleDateFormat.parse("07-Jul-2002").getTime(), 5.31);
        arrayList.add("7D - 5.31");
        xYSeries.add((double)simpleDateFormat.parse("08-Jul-2002").getTime(), 5.36);
        arrayList.add("8D - 5.36");
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        CustomXYToolTipGenerator customXYToolTipGenerator = new CustomXYToolTipGenerator();
        customXYToolTipGenerator.addToolTipSeries(arrayList);
        StandardXYURLGenerator standardXYURLGenerator = new StandardXYURLGenerator("xy_details.jsp");
        DateAxis dateAxis = new DateAxis("");
        NumberAxis numberAxis = new NumberAxis("");
        numberAxis.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYSeriesCollection, dateAxis, numberAxis, null);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(3, customXYToolTipGenerator, standardXYURLGenerator);
        standardXYItemRenderer.setShapesFilled(true);
        xYPlot.setRenderer(standardXYItemRenderer);
        JFreeChart jFreeChart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, xYPlot, false);
        jFreeChart.setBackgroundPaint(Color.white);
        try {
            ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo(new StandardEntityCollection());
            File file = new File("xychart100.png");
            ChartUtilities.saveChartAsPNG(file, jFreeChart, 600, 400, chartRenderingInfo);
            File file2 = new File("xychart100.html");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
            printWriter.println("<HTML>");
            printWriter.println("<HEAD><TITLE>JFreeChart Image Map Demo</TITLE></HEAD>");
            printWriter.println("<BODY>");
            printWriter.println("<IMG SRC=\"xychart100.png\" WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\">");
            printWriter.println("</BODY>");
            printWriter.println("</HTML>");
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }
}

