/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;

public class ImageMapDemo1 {
    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{56.0, -12.0, 34.0, 76.0, 56.0, 100.0, 67.0, 45.0}, {37.0, 45.0, 67.0, 25.0, 34.0, 34.0, 100.0, 53.0}, {43.0, 54.0, 34.0, 34.0, 87.0, 64.0, 73.0, 12.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Series ", "Type ", (double[][])dArrayArray);
        JFreeChart jFreeChart = null;
        Cloneable cloneable = new CategoryAxis("Category");
        Serializable serializable = new NumberAxis("Value");
        Serializable serializable2 = new BarRenderer();
        serializable2.setToolTipGenerator(new StandardCategoryToolTipGenerator());
        serializable2.setItemURLGenerator(new StandardCategoryURLGenerator("bar_chart_detail.jsp"));
        Object object = new CategoryPlot(categoryDataset, (CategoryAxis)cloneable, (ValueAxis)serializable, (CategoryItemRenderer)((Object)serializable2));
        ((CategoryPlot)object).setOrientation(PlotOrientation.VERTICAL);
        jFreeChart = new JFreeChart("Bar Chart", JFreeChart.DEFAULT_TITLE_FONT, (Plot)object, true);
        jFreeChart.setBackgroundPaint(Color.white);
        try {
            cloneable = new ChartRenderingInfo(new StandardEntityCollection());
            serializable = new File("barchart100.png");
            ChartUtilities.saveChartAsPNG((File)serializable, jFreeChart, 600, 400, (ChartRenderingInfo)cloneable);
            serializable2 = new File("barchart100.html");
            object = new BufferedOutputStream(new FileOutputStream((File)serializable2));
            PrintWriter printWriter = new PrintWriter((OutputStream)object);
            printWriter.println("<HTML>");
            printWriter.println("<HEAD><TITLE>JFreeChart Image Map Demo</TITLE></HEAD>");
            printWriter.println("<BODY>");
            printWriter.println("<IMG SRC=\"barchart100.png\" WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\">");
            printWriter.println("</BODY>");
            printWriter.println("</HTML>");
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }
}

