/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.RenderingHints;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class FastScatterPlotDemo
extends ApplicationFrame {
    private static final int COUNT = 500000;
    private float[][] data = new float[2][500000];

    public FastScatterPlotDemo(String string) {
        super(string);
        this.populateData();
        NumberAxis numberAxis = new NumberAxis("X");
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis("Y");
        numberAxis2.setAutoRangeIncludesZero(false);
        FastScatterPlot fastScatterPlot = new FastScatterPlot(this.data, numberAxis, numberAxis2);
        JFreeChart jFreeChart = new JFreeChart("Fast Scatter Plot", fastScatterPlot);
        jFreeChart.getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartPanel chartPanel = new ChartPanel(jFreeChart, true);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMinimumDrawHeight(10);
        chartPanel.setMaximumDrawHeight(2000);
        chartPanel.setMinimumDrawWidth(20);
        chartPanel.setMaximumDrawWidth(2000);
        this.setContentPane(chartPanel);
    }

    private void populateData() {
        for (int i = 0; i < this.data[0].length; ++i) {
            float f;
            this.data[0][i] = f = (float)i + 100000.0f;
            this.data[1][i] = 100000.0f + (float)Math.random() * 500000.0f;
        }
    }

    public static void main(String[] stringArray) {
        FastScatterPlotDemo fastScatterPlotDemo = new FastScatterPlotDemo("Fast Scatter Plot Demo");
        fastScatterPlotDemo.pack();
        RefineryUtilities.centerFrameOnScreen(fastScatterPlotDemo);
        fastScatterPlotDemo.setVisible(true);
    }
}

