/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class DynamicDataDemo2
extends ApplicationFrame
implements ActionListener {
    private TimeSeries series1 = new TimeSeries("Random 1", Millisecond.class);
    private TimeSeries series2 = new TimeSeries("Random 2", Millisecond.class);
    private double lastValue1 = 100.0;
    private double lastValue2 = 500.0;

    public DynamicDataDemo2(String string) {
        super(string);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(this.series1);
        TimeSeriesCollection timeSeriesCollection2 = new TimeSeriesCollection(this.series2);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Dynamic Data Demo 2", "Time", "Value", timeSeriesCollection, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        valueAxis.setAutoRange(true);
        valueAxis.setFixedAutoRange(60000.0);
        xYPlot.setDataset(1, timeSeriesCollection2);
        NumberAxis numberAxis = new NumberAxis("Range Axis 2");
        numberAxis.setAutoRangeIncludesZero(false);
        xYPlot.setRenderer(1, new DefaultXYItemRenderer());
        xYPlot.setRangeAxis(1, numberAxis);
        xYPlot.mapDatasetToRangeAxis(1, 1);
        JPanel jPanel = new JPanel(new BorderLayout());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        jPanel.add(chartPanel);
        JButton jButton = new JButton("Add To Series 1");
        jButton.setActionCommand("ADD_DATA_1");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Add To Series 2");
        jButton2.setActionCommand("ADD_DATA_2");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Add To Both");
        jButton3.setActionCommand("ADD_BOTH");
        jButton3.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "South");
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Millisecond millisecond;
        double d;
        boolean bl = false;
        boolean bl2 = false;
        if (actionEvent.getActionCommand().equals("ADD_DATA_1")) {
            bl = true;
        } else if (actionEvent.getActionCommand().equals("ADD_DATA_2")) {
            bl2 = true;
        } else if (actionEvent.getActionCommand().equals("ADD_BOTH")) {
            bl = true;
            bl2 = true;
        }
        if (bl) {
            d = 0.9 + 0.2 * Math.random();
            this.lastValue1 *= d;
            millisecond = new Millisecond();
            System.out.println("Now = " + millisecond.toString());
            this.series1.add((RegularTimePeriod)new Millisecond(), this.lastValue1);
        }
        if (bl2) {
            d = 0.9 + 0.2 * Math.random();
            this.lastValue2 *= d;
            millisecond = new Millisecond();
            System.out.println("Now = " + millisecond.toString());
            this.series2.add((RegularTimePeriod)new Millisecond(), this.lastValue2);
        }
    }

    public static void main(String[] stringArray) {
        DynamicDataDemo2 dynamicDataDemo2 = new DynamicDataDemo2("Dynamic Data Demo 2");
        dynamicDataDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(dynamicDataDemo2);
        dynamicDataDemo2.setVisible(true);
    }
}

