/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class DualAxisDemo5
extends ApplicationFrame {
    public DualAxisDemo5(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset1();
        CategoryDataset categoryDataset2 = this.createDataset2();
        JFreeChart jFreeChart = this.createChart(categoryDataset, categoryDataset2);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset1() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(null, (Comparable)((Object)"Dummy 1"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(null, (Comparable)((Object)"Dummy 1"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(null, (Comparable)((Object)"Dummy 1"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(null, (Comparable)((Object)"Dummy 1"), (Comparable)((Object)"Category 4"));
        return defaultCategoryDataset;
    }

    private CategoryDataset createDataset2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(null, (Comparable)((Object)"Dummy 2"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(null, (Comparable)((Object)"Dummy 2"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(null, (Comparable)((Object)"Dummy 2"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(null, (Comparable)((Object)"Dummy 2"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(75.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(87.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(96.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(68.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 4"));
        return defaultCategoryDataset;
    }

    private JFreeChart createChart(CategoryDataset categoryDataset, CategoryDataset categoryDataset2) {
        CategoryAxis categoryAxis = new CategoryAxis("Category");
        NumberAxis numberAxis = new NumberAxis("Value");
        BarRenderer barRenderer = new BarRenderer();
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, barRenderer){

            public LegendItemCollection getLegendItems() {
                Object object;
                Object object2;
                LegendItemCollection legendItemCollection = new LegendItemCollection();
                CategoryDataset categoryDataset = this.getDataset();
                if (categoryDataset != null && (object2 = this.getRenderer()) != null) {
                    object = object2.getLegendItem(0, 0);
                    legendItemCollection.add((LegendItem)object);
                }
                if ((object2 = this.getDataset(1)) != null && (object = this.getRenderer(1)) != null) {
                    LegendItem legendItem = object.getLegendItem(1, 1);
                    legendItemCollection.add(legendItem);
                }
                return legendItemCollection;
            }
        };
        JFreeChart jFreeChart = new JFreeChart("Dual Axis Bar Chart", categoryPlot);
        jFreeChart.setBackgroundPaint(Color.white);
        categoryPlot.setBackgroundPaint(new Color(238, 238, 255));
        categoryPlot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        categoryPlot.setDataset(1, categoryDataset2);
        categoryPlot.mapDatasetToRangeAxis(1, 1);
        NumberAxis numberAxis2 = new NumberAxis("Secondary");
        categoryPlot.setRangeAxis(1, numberAxis2);
        categoryPlot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        BarRenderer barRenderer2 = new BarRenderer();
        categoryPlot.setRenderer(1, barRenderer2);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        DualAxisDemo5 dualAxisDemo5 = new DualAxisDemo5("Dual Axis Demo 5");
        dualAxisDemo5.pack();
        RefineryUtilities.centerFrameOnScreen(dualAxisDemo5);
        dualAxisDemo5.setVisible(true);
    }
}

