/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class DualAxisDemo
extends ApplicationFrame {
    public DualAxisDemo(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset1();
        JFreeChart jFreeChart = ChartFactory.createBarChart("Dual Axis Chart", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setBackgroundPaint(new Color(238, 238, 255));
        categoryPlot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
        CategoryDataset categoryDataset2 = this.createDataset2();
        categoryPlot.setDataset(1, categoryDataset2);
        categoryPlot.mapDatasetToRangeAxis(1, 1);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        NumberAxis numberAxis = new NumberAxis("Secondary");
        categoryPlot.setRangeAxis(1, numberAxis);
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        lineAndShapeRenderer.setToolTipGenerator(new StandardCategoryToolTipGenerator());
        categoryPlot.setRenderer(1, lineAndShapeRenderer);
        categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset1() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 6"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 7"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 8"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 6"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 7"));
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 8"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 6"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 7"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 8"));
        return defaultCategoryDataset;
    }

    private CategoryDataset createDataset2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(15.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 1"));
        defaultCategoryDataset.addValue(24.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 2"));
        defaultCategoryDataset.addValue(31.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 3"));
        defaultCategoryDataset.addValue(25.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 4"));
        defaultCategoryDataset.addValue(56.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 5"));
        defaultCategoryDataset.addValue(37.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 6"));
        defaultCategoryDataset.addValue(77.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 7"));
        defaultCategoryDataset.addValue(18.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Category 8"));
        return defaultCategoryDataset;
    }

    public static void main(String[] stringArray) {
        DualAxisDemo dualAxisDemo = new DualAxisDemo("Dual Axis Demo");
        dualAxisDemo.pack();
        RefineryUtilities.centerFrameOnScreen(dualAxisDemo);
        dualAxisDemo.setVisible(true);
    }
}

