/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CrosshairDemo1
extends ApplicationFrame {
    public CrosshairDemo1(String string) {
        super(string);
        XYDataset xYDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private XYDataset createDataset() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"First"));
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 4.0);
        xYSeries.add(3.0, 3.0);
        xYSeries.add(4.0, 5.0);
        xYSeries.add(5.0, 5.0);
        xYSeries.add(6.0, 7.0);
        xYSeries.add(7.0, 7.0);
        xYSeries.add(8.0, 8.0);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Second"));
        xYSeries2.add(1.0, 5.0);
        xYSeries2.add(2.0, 7.0);
        xYSeries2.add(3.0, 6.0);
        xYSeries2.add(4.0, 8.0);
        xYSeries2.add(5.0, 4.0);
        xYSeries2.add(6.0, 4.0);
        xYSeries2.add(7.0, 2.0);
        xYSeries2.add(8.0, 1.0);
        XYSeries xYSeries3 = new XYSeries((Comparable)((Object)"Third"));
        xYSeries3.add(3.0, 4.0);
        xYSeries3.add(4.0, 3.0);
        xYSeries3.add(5.0, 2.0);
        xYSeries3.add(6.0, 3.0);
        xYSeries3.add(7.0, 6.0);
        xYSeries3.add(8.0, 3.0);
        xYSeries3.add(9.0, 4.0);
        xYSeries3.add(10.0, 3.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        xYSeriesCollection.addSeries(xYSeries3);
        return xYSeriesCollection;
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Crosshair Demo 1", "X", "Y", xYDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setDomainCrosshairLockedOnData(true);
        xYPlot.setRangeCrosshairVisible(true);
        xYPlot.setRangeCrosshairLockedOnData(true);
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)xYPlot.getRenderer();
        standardXYItemRenderer.setPlotShapes(true);
        standardXYItemRenderer.setShapesFilled(true);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        CrosshairDemo1 crosshairDemo1 = new CrosshairDemo1("Crosshair Demo 1");
        crosshairDemo1.pack();
        RefineryUtilities.centerFrameOnScreen(crosshairDemo1);
        crosshairDemo1.setVisible(true);
    }
}

