/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.util.Date;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ClipPath;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.ContourPlot;
import org.jfree.data.contour.ContourDataset;
import org.jfree.data.contour.DefaultContourDataset;
import org.jfree.data.contour.NonGridContourDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ContourPlotDemo2
extends ApplicationFrame {
    private ValueAxis xAxis = null;
    private NumberAxis yAxis = null;
    private ColorBar zColorBar = null;
    private static boolean xIsDate = false;
    private static boolean asPoints = false;
    private static boolean xIsLog = false;
    private static boolean yIsLog = false;
    private static boolean zIsLog = false;
    private static boolean xIsInverted = true;
    private static boolean yIsInverted = false;
    private static boolean zIsInverted = false;
    private static boolean annotate = false;
    private static int numX = 10;
    private static int numY = 20;
    private static double ratio = 0.0;
    private double[] tmpDoubleY = null;
    private double[] tmpDoubleX = null;
    private double[] tmpDoubleZ = null;
    private double[] xOutline = null;
    private double[] yOutline = null;
    static boolean drawOutline = false;
    static boolean fillOutline = false;
    static int power = 4;

    public ContourPlotDemo2(String string) {
        super(string);
        JFreeChart jFreeChart = this.createContourPlot();
        ChartPanel chartPanel = new ChartPanel(jFreeChart, true, true, true, true, true);
        chartPanel.setPreferredSize(new Dimension(1000, 800));
        chartPanel.setMaximumDrawHeight(100000);
        chartPanel.setMaximumDrawWidth(100000);
        chartPanel.setFillZoomRectangle(true);
        this.setContentPane(chartPanel);
    }

    private JFreeChart createContourPlot() {
        Object object;
        if (xIsDate) {
            this.xAxis = new DateAxis("X Values");
            xIsLog = false;
        } else {
            this.xAxis = xIsLog ? new LogarithmicAxis("X Values") : new NumberAxis("X Values");
        }
        this.yAxis = yIsLog ? new LogarithmicAxis("Y Values") : new NumberAxis("Y Values");
        this.zColorBar = zIsLog ? new ColorBar("Color Values") : new ColorBar("Color Values");
        if (this.xAxis instanceof NumberAxis) {
            ((NumberAxis)this.xAxis).setAutoRangeIncludesZero(false);
            ((NumberAxis)this.xAxis).setInverted(xIsInverted);
        }
        this.yAxis.setAutoRangeIncludesZero(false);
        this.yAxis.setInverted(yIsInverted);
        if (!xIsDate) {
            ((NumberAxis)this.xAxis).setLowerMargin(0.0);
            ((NumberAxis)this.xAxis).setUpperMargin(0.0);
        }
        this.yAxis.setLowerMargin(0.0);
        this.yAxis.setUpperMargin(0.0);
        if (!xIsDate) {
            this.xAxis.setRange(10.5, 15.0);
        }
        this.yAxis.setRange(3.5, 7.0);
        this.zColorBar.getAxis().setInverted(zIsInverted);
        this.zColorBar.getAxis().setTickMarksVisible(true);
        ContourDataset contourDataset = this.createDataset();
        ContourPlot contourPlot = new ContourPlot(contourDataset, this.xAxis, this.yAxis, this.zColorBar);
        if (xIsDate) {
            ratio = Math.abs(ratio);
        }
        if (asPoints) {
            contourPlot.setRenderAsPoints(true);
        }
        contourPlot.setDataAreaRatio(ratio);
        if (annotate) {
            if (asPoints) {
                object = contourDataset.getXValues();
                Number[] numberArray = contourDataset.getYValues();
                Font font = new Font("SansSerif", 0, 20);
                for (int i = 0; i < ((Number[])object).length; ++i) {
                    XYTextAnnotation xYTextAnnotation = new XYTextAnnotation(Integer.toString(i), ((Number)object[i]).doubleValue(), numberArray[i].doubleValue());
                    xYTextAnnotation.setFont(font);
                    contourPlot.addAnnotation(xYTextAnnotation);
                }
            } else {
                object = new Font("SansSerif", 0, 20);
                for (int i = 0; i < this.tmpDoubleX.length; ++i) {
                    XYTextAnnotation xYTextAnnotation = new XYTextAnnotation(Integer.toString(i), this.tmpDoubleX[i], this.tmpDoubleY[i]);
                    xYTextAnnotation.setFont((Font)object);
                    contourPlot.addAnnotation(xYTextAnnotation);
                }
            }
        }
        if (fillOutline || drawOutline) {
            this.initShoreline();
            contourPlot.setClipPath(new ClipPath(this.xOutline, this.yOutline, true, fillOutline, drawOutline));
        }
        object = new JFreeChart("Contour Plot", null, contourPlot, false);
        ((JFreeChart)object).setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        return object;
    }

    private ContourDataset createDataset() {
        this.initData();
        Object[] objectArray = (Double[])DefaultContourDataset.formObjectArray(this.tmpDoubleX);
        Object[] objectArray2 = (Double[])DefaultContourDataset.formObjectArray(this.tmpDoubleY);
        Object[] objectArray3 = (Double[])DefaultContourDataset.formObjectArray(this.tmpDoubleZ);
        Object[] objectArray4 = new Date[this.tmpDoubleX.length];
        for (int i = 0; i < this.tmpDoubleX.length; ++i) {
            objectArray4[i] = new Date((long)(1000.0 * this.tmpDoubleX[i]));
        }
        DefaultContourDataset defaultContourDataset = null;
        defaultContourDataset = xIsDate ? (asPoints ? new DefaultContourDataset((Comparable)((Object)"Contouring"), objectArray4, objectArray2, objectArray3) : new NonGridContourDataset("Contouring", objectArray4, objectArray2, objectArray3)) : (!asPoints ? new NonGridContourDataset("Contouring", objectArray, objectArray2, objectArray3, numX, numY, power) : new DefaultContourDataset((Comparable)((Object)"Contouring"), objectArray, objectArray2, objectArray3));
        return defaultContourDataset;
    }

    protected static boolean processArgs(String[] stringArray) {
        String[] stringArray2 = new String[]{"-?", "-date", "-vertical", "-points", "-outline", "-filled", "-ratio:", "-numX:", "-numY:", "-power:", "-annotate"};
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            block14: for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].startsWith(stringArray2[j])) continue;
                bl = true;
                int n = 0;
                String string = null;
                switch (j) {
                    case 0: {
                        ContourPlotDemo2.usage();
                        return false;
                    }
                    case 1: {
                        xIsDate = true;
                        continue block14;
                    }
                    case 2: {
                        continue block14;
                    }
                    case 3: {
                        asPoints = true;
                        continue block14;
                    }
                    case 4: {
                        drawOutline = true;
                        continue block14;
                    }
                    case 5: {
                        fillOutline = true;
                        continue block14;
                    }
                    case 6: {
                        n = stringArray[i].indexOf(58);
                        string = stringArray[i].substring(n + 1);
                        ratio = Double.parseDouble(string);
                        continue block14;
                    }
                    case 7: {
                        n = stringArray[i].indexOf(58);
                        string = stringArray[i].substring(n + 1);
                        numX = Integer.parseInt(string);
                        continue block14;
                    }
                    case 8: {
                        n = stringArray[i].indexOf(58);
                        string = stringArray[i].substring(n + 1);
                        numY = Integer.parseInt(string);
                        continue block14;
                    }
                    case 9: {
                        n = stringArray[i].indexOf(58);
                        string = stringArray[i].substring(n + 1);
                        power = Integer.parseInt(string);
                        continue block14;
                    }
                    case 10: {
                        annotate = true;
                        continue block14;
                    }
                    default: {
                        System.out.println("Only 11 options available, update options array");
                    }
                }
            }
            if (bl) continue;
            System.out.println("Unknown option: " + stringArray[i]);
            ContourPlotDemo2.usage();
            return false;
        }
        return true;
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("ContourPlotDemo2 -? -date -vertical -points -outline -filled -ratio:value -numX:value -numY:value");
        System.out.println("Where:");
        System.out.println("-? displays usage and exits");
        System.out.println("-date the X axis will be a date");
        System.out.println("-vertical the colorbar will be drawn vertically");
        System.out.println("-points demos plotting data as point (not grid)");
        System.out.println("-outline draws shoreline outline and clips dataArea");
        System.out.println("-filled fills shoreline and clips dataArea");
        System.out.println("-ratio forces plot to maintain aspect ratio (Y/X) indicated by value");
        System.out.println("       positive values are in pixels, while negative is in plot units");
        System.out.println("-numX number of values to generate along the X axis");
        System.out.println("-numY number of values to generate along the Y axis");
    }

    public static void main(String[] stringArray) {
        if (!ContourPlotDemo2.processArgs(stringArray)) {
            System.exit(1);
        }
        ContourPlotDemo2 contourPlotDemo2 = new ContourPlotDemo2("ContourPlot Demo");
        contourPlotDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(contourPlotDemo2);
        contourPlotDemo2.setVisible(true);
    }

    private void initData() {
        double[] dArray = new double[]{6.782, 6.79, 6.882, 6.289, 6.339, 6.426, 6.584, 5.532, 5.788, 5.922, 6.053, 4.008, 4.185, 4.456, 4.801, 4.779, 4.572, 5.202, 5.613, 5.893};
        double[] dArray2 = new double[]{14.508, 14.413, 14.329, 14.512, 14.284, 14.085, 13.793, 13.603, 13.492, 13.229, 12.956, 11.087, 11.062, 10.937, 11.169, 11.837, 12.182, 12.802, 12.782, 12.687};
        double[] dArray3 = new double[]{2.03, 1.23, 0.86, 3.99, 2.38, 3.0, 3.08, 6.63, 6.84, 7.38, 6.99, 10.4, 11.11, 10.97, 11.22, 11.25, 10.68, 7.93, 8.17, 7.4};
        this.tmpDoubleY = new double[dArray.length];
        this.tmpDoubleX = new double[dArray2.length];
        this.tmpDoubleZ = new double[dArray3.length];
        for (int i = 0; i < this.tmpDoubleX.length; ++i) {
            this.tmpDoubleX[i] = dArray2[i];
            this.tmpDoubleY[i] = dArray[i];
            this.tmpDoubleZ[i] = dArray3[i];
        }
    }

    private void initShoreline() {
        double[] dArray = new double[]{6.93, 6.91, 6.9, 6.88, 6.86, 6.85, 6.83, 6.85, 6.86, 6.88, 6.9, 6.9, 6.9, 6.89, 6.88, 6.86, 6.84, 6.83, 6.81, 6.79, 6.78, 6.76, 6.74, 6.73, 6.71, 6.69, 6.68, 6.66, 6.64, 6.63, 6.61, 6.59, 6.58, 6.56, 6.54, 6.53, 6.52, 6.5, 6.49, 6.47, 6.45, 6.44, 6.42, 6.4, 6.39, 6.37, 6.35, 6.34, 6.32, 6.3, 6.29, 6.27, 6.25, 6.24, 6.22, 6.2, 6.19, 6.17, 6.15, 6.14, 6.12, 6.1, 6.08, 6.07, 6.05, 6.04, 6.02, 6.0, 5.98, 5.97, 5.95, 5.93, 5.92, 5.9, 5.88, 5.87, 5.85, 5.83, 5.82, 5.8, 5.78, 5.77, 5.76, 5.74, 5.73, 5.71, 5.7, 5.68, 5.66, 5.65, 5.63, 5.62, 5.6, 5.59, 5.59, 5.57, 5.56, 5.54, 5.52, 5.51, 5.49, 5.47, 5.46, 5.44, 5.42, 5.41, 5.39, 5.37, 5.36, 5.34, 5.34, 5.33, 5.32, 5.31, 5.3, 5.3, 5.3, 5.29, 5.29, 5.29, 5.29, 5.29, 5.3, 5.31, 5.32, 5.34, 5.35, 5.36, 5.36, 5.38, 5.39, 5.4, 5.42, 5.42, 5.42, 5.42, 5.42, 5.42, 5.41, 5.41, 5.41, 5.4, 5.38, 5.37, 5.35, 5.33, 5.32, 5.3, 5.28, 5.27, 5.25, 5.23, 5.22, 5.21, 5.19, 5.17, 5.16, 5.14, 5.12, 5.11, 5.09, 5.07, 5.06, 5.06, 5.05, 5.04, 5.04, 5.03, 5.02, 5.0, 4.99, 4.97, 4.95, 4.93, 4.92, 4.91, 4.9, 4.89, 4.87, 4.86, 4.84, 4.82, 4.8, 4.79, 4.77, 4.75, 4.74, 4.72, 4.7, 4.69, 4.67, 4.65, 4.64, 4.62, 4.6, 4.58, 4.57, 4.55, 4.54, 4.52, 4.5, 4.49, 4.47, 4.46, 4.44, 4.42, 4.41, 4.39, 4.38, 4.37, 4.36, 4.34, 4.32, 4.31, 4.29, 4.27, 4.26, 4.25, 4.24, 4.22, 4.21, 4.19, 4.18, 4.17, 4.15, 4.14, 4.12, 4.1, 4.08, 4.07, 4.05, 4.04, 4.02, 4.01, 4.01, 4.01, 4.0, 4.0, 4.0, 3.99, 3.99, 3.98, 3.98, 3.97, 3.97, 3.97, 3.96, 3.96, 3.94, 3.93, 3.91, 3.9, 3.89, 3.89, 3.88, 3.86, 3.85, 3.84, 3.83, 3.82, 3.8, 3.79, 3.77, 3.75, 3.74, 3.72, 3.71, 3.69, 3.69, 3.69, 3.69, 3.69, 3.69, 3.71, 3.72, 3.72, 3.74, 3.75, 3.77, 3.78, 3.8, 3.81, 3.83, 3.85, 3.86, 3.88, 3.9, 3.91, 3.93, 3.95, 3.96, 3.98, 4.0, 4.01, 4.03, 4.04, 4.06, 4.08, 4.09, 4.11, 4.13, 4.14, 4.16, 4.18, 4.19, 4.21, 4.23, 4.24, 4.26, 4.28, 4.29, 4.31, 4.33, 4.34, 4.36, 4.38, 4.39, 4.41, 4.43, 4.44, 4.46, 4.48, 4.49, 4.51, 4.53, 4.54, 4.56, 4.58, 4.59, 4.61, 4.62, 4.64, 4.66, 4.67, 4.69, 4.7, 4.72, 4.73, 4.75, 4.76, 4.78, 4.79, 4.81, 4.82, 4.83, 4.84, 4.86, 4.87, 4.88, 4.9, 4.91, 4.93, 4.94, 4.95, 4.97, 4.98, 5.0, 5.01, 5.02, 5.04, 5.06, 5.07, 5.09, 5.1, 5.12, 5.14, 5.15, 5.17, 5.19, 5.2, 5.22, 5.24, 5.25, 5.27, 5.29, 5.3, 5.32, 5.34, 5.36, 5.37, 5.39, 5.41, 5.42, 5.44, 5.45, 5.47, 5.48, 5.5, 5.51, 5.52, 5.54, 5.55, 5.57, 5.58, 5.6, 5.61, 5.63, 5.65, 5.66, 5.68, 5.69, 5.7, 5.71, 5.73, 5.74, 5.76, 5.75, 5.75, 5.76, 5.77, 5.79, 5.8, 5.82, 5.84, 5.85, 5.87, 5.88, 5.9, 5.91, 5.93, 5.94, 5.96, 5.97, 5.99, 5.99, 6.0, 6.0, 5.98, 5.98, 5.97, 5.98, 6.0, 5.98, 5.98, 6.0, 6.02, 6.03, 6.05, 6.06, 6.07, 6.07, 6.06, 6.04, 6.03, 6.01, 6.03, 6.04, 6.06, 6.08, 6.09, 6.1, 6.11, 6.13, 6.13, 6.14, 6.15, 6.16, 6.17, 6.18, 6.18, 6.18, 6.19, 6.21, 6.22, 6.23, 6.24, 6.25, 6.25, 6.26, 6.27, 6.29, 6.31, 6.32, 6.34, 6.35, 6.36, 6.38, 6.39, 6.41, 6.43, 6.45, 6.46, 6.48, 6.49, 6.51, 6.52, 6.54, 6.55, 6.56, 6.57, 6.59, 6.6, 6.62, 6.63, 6.65, 6.66, 6.67, 6.69, 6.7, 6.72, 6.73, 6.75, 6.76, 6.77, 6.79, 6.8, 6.81, 6.83, 6.83, 6.85, 6.86, 6.87, 6.88, 6.88, 6.89, 6.9, 6.9, 6.91, 6.91, 6.91, 6.9, 6.91, 6.92, 6.92, 6.93, 6.93, 6.93, 6.91, 6.9, 6.88, 6.87, 6.88, 6.9, 6.9, 6.92, 6.94, 6.95, 6.96};
        double[] dArray2 = new double[]{14.6171, 14.5984, 14.5883, 14.5818, 14.5626, 14.5435, 14.5257, 14.5462, 14.5653, 14.5854, 14.6027, 14.6256, 14.6482, 14.6707, 14.6934, 14.7161, 14.7312, 14.7494, 14.7604, 14.7746, 14.7856, 14.7939, 14.804, 14.8141, 14.8175, 14.8199, 14.8247, 14.8244, 14.8255, 14.8258, 14.8215, 14.8172, 14.8084, 14.7978, 14.7836, 14.7604, 14.7376, 14.7193, 14.7142, 14.7117, 14.7074, 14.7017, 14.6952, 14.6828, 14.6722, 14.6621, 14.6461, 14.6378, 14.6313, 14.6252, 14.6186, 14.6013, 14.5813, 14.577, 14.5736, 14.5725, 14.5632, 14.5513, 14.547, 14.5391, 14.5335, 14.5152, 14.4961, 14.4738, 14.4619, 14.4387, 14.4209, 14.4031, 14.3934, 14.3847, 14.3768, 14.3698, 14.3628, 14.35, 14.3353, 14.3148, 14.3029, 14.295, 14.2826, 14.2694, 14.2633, 14.2409, 14.2222, 14.2017, 14.1789, 14.1566, 14.1406, 14.1336, 14.1249, 14.1174, 14.105, 14.0822, 14.0599, 14.0371, 14.0146, 14.0009, 13.9939, 13.9878, 13.9777, 13.9662, 13.9525, 13.9306, 13.9156, 13.9023, 13.8917, 13.8806, 13.8692, 13.8586, 13.8412, 13.8189, 13.7965, 13.7741, 13.7509, 13.728, 13.7047, 13.6809, 13.658, 13.6351, 13.6126, 13.5896, 13.5667, 13.5437, 13.5207, 13.4981, 13.4781, 13.4716, 13.448, 13.425, 13.4015, 13.3788, 13.3561, 13.3335, 13.3099, 13.2865, 13.2631, 13.2406, 13.2176, 13.1952, 13.1727, 13.1503, 13.1278, 13.1054, 13.1042, 13.1121, 13.1155, 13.1301, 13.1393, 13.1449, 13.151, 13.1494, 13.1465, 13.1426, 13.1202, 13.107, 13.0968, 13.0835, 13.064, 13.0547, 13.0558, 13.0479, 13.0297, 13.0115, 12.9891, 12.9667, 12.9442, 12.9205, 12.8972, 12.8748, 12.852, 12.8337, 12.8173, 12.7973, 12.788, 12.7757, 12.7534, 12.731, 12.7086, 12.6863, 12.6635, 12.6412, 12.6212, 12.6115, 12.6054, 12.598, 12.5933, 12.5813, 12.5717, 12.5584, 12.546, 12.5345, 12.5239, 12.5205, 12.514, 12.5061, 12.5, 12.4971, 12.4937, 12.4791, 12.4662, 12.4511, 12.4284, 12.4061, 12.3874, 12.3804, 12.3739, 12.3723, 12.372, 12.3628, 12.3395, 12.3171, 12.3015, 12.2964, 12.3105, 12.3121, 12.301, 12.2837, 12.2614, 12.2382, 12.2153, 12.1931, 12.1707, 12.148, 12.1252, 12.1024, 12.0805, 12.0713, 12.0513, 12.0294, 12.0103, 11.9939, 11.9711, 11.9488, 11.9265, 11.9041, 11.8817, 11.8592, 11.8368, 11.8143, 11.7905, 11.768, 11.7443, 11.7218, 11.6989, 11.6756, 11.6527, 11.6302, 11.6078, 11.5849, 11.572, 11.5808, 11.5576, 11.5343, 11.5119, 11.4891, 11.4667, 11.4443, 11.4202, 11.3969, 11.3745, 11.3517, 11.3349, 11.3324, 11.3267, 11.3198, 11.311, 11.2886, 11.2663, 11.2467, 11.2239, 11.2, 11.1761, 11.1527, 11.1297, 11.107, 11.0831, 11.0605, 11.0378, 11.0142, 10.9969, 10.9733, 10.9507, 10.932, 10.9129, 10.8996, 10.8899, 10.8803, 10.8625, 10.8398, 10.8207, 10.8083, 10.7928, 10.7836, 10.7717, 10.7503, 10.7357, 10.7126, 10.6989, 10.7027, 10.6908, 10.6807, 10.6764, 10.6767, 10.6832, 10.6974, 10.6976, 10.6902, 10.6904, 10.697, 10.7013, 10.6911, 10.6878, 10.6763, 10.6734, 10.6723, 10.6734, 10.6701, 10.669, 10.6597, 10.6519, 10.6467, 10.6379, 10.6224, 10.6213, 10.6279, 10.6339, 10.6378, 10.6448, 10.6607, 10.683, 10.7058, 10.7214, 10.7419, 10.7587, 10.7815, 10.8011, 10.8234, 10.8448, 10.8675, 10.8903, 10.9126, 10.9349, 10.9581, 10.9805, 11.0033, 11.0261, 11.0484, 11.0716, 11.0939, 11.1172, 11.14, 11.16, 11.1823, 11.2046, 11.227, 11.2493, 11.2702, 11.293, 11.3153, 11.3377, 11.3609, 11.3805, 11.4009, 11.4233, 11.4438, 11.462, 11.4784, 11.4944, 11.5162, 11.5318, 11.546, 11.5584, 11.5703, 11.5804, 11.5897, 11.602, 11.6099, 11.6178, 11.623, 11.6349, 11.6446, 11.6498, 11.6577, 11.6777, 11.7005, 11.7232, 11.7455, 11.7678, 11.7906, 11.8116, 11.8339, 11.8562, 11.8786, 11.8999, 11.9227, 11.945, 11.9678, 11.9856, 12.0024, 12.0166, 12.0304, 12.0531, 12.0755, 12.0984, 12.1207, 12.1344, 12.1567, 12.1793, 12.2023, 12.2247, 12.247, 12.2652, 12.274, 12.2941, 12.3042, 12.3265, 12.3488, 12.3716, 12.3939, 12.4162, 12.4394, 12.4612, 12.4844, 12.5067, 12.53, 12.5524, 12.5753, 12.5983, 12.6209, 12.6434, 12.6504, 12.6434, 12.6549, 12.6443, 12.6214, 12.6045, 12.5962, 12.5978, 12.6201, 12.6425, 12.6653, 12.6877, 12.7086, 12.7147, 12.7189, 12.7074, 12.718, 12.7277, 12.7383, 12.7498, 12.7707, 12.7931, 12.8155, 12.8382, 12.8611, 12.8835, 12.9059, 12.9287, 12.951, 12.9743, 12.9968, 13.0207, 13.044, 13.064, 13.0836, 13.1068, 13.1302, 13.1531, 13.1764, 13.1997, 13.222, 13.2443, 13.2576, 13.2695, 13.2873, 13.3105, 13.3329, 13.3552, 13.3784, 13.3944, 13.4113, 13.4344, 13.4568, 13.4781, 13.5004, 13.5228, 13.5415, 13.561, 13.5834, 13.6058, 13.6282, 13.645, 13.6583, 13.6806, 13.703, 13.7239, 13.7472, 13.7695, 13.7864, 13.8092, 13.8328, 13.8538, 13.8761, 13.8984, 13.9212, 13.9449, 13.9672, 13.9913, 14.0141, 14.0365, 14.0589, 14.0816, 14.1049, 14.1273, 14.1502, 14.1725, 14.195, 14.2179, 14.2408, 14.2637, 14.2889, 14.3115, 14.3339, 14.3563, 14.3787, 14.4021, 14.4245, 14.4475, 14.4702, 14.4924, 14.4868, 14.4644, 14.4868, 14.5073, 14.5297, 14.5515, 14.5662, 14.5885, 14.5938};
        this.xOutline = new double[dArray2.length];
        this.yOutline = new double[dArray.length];
        for (int i = 0; i < this.xOutline.length; ++i) {
            this.xOutline[i] = dArray2[i];
            this.yOutline[i] = dArray[i];
        }
    }
}

