/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.util.Date;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.ContourPlot;
import org.jfree.data.contour.ContourDataset;
import org.jfree.data.contour.DefaultContourDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ContourPlotDemo
extends ApplicationFrame {
    private ValueAxis xAxis = null;
    private NumberAxis yAxis = null;
    private ColorBar zColorBar = null;
    private static boolean xIsDate = false;
    private static boolean xIsLog = false;
    private static boolean yIsLog = false;
    private static boolean zIsLog = false;
    private static boolean xIsInverted = false;
    private static boolean yIsInverted = false;
    private static boolean zIsInverted = false;
    private static boolean makeHoles = false;
    private static int numX = 10;
    private static int numY = 20;
    private static double ratio = 0.0;
    public ChartPanel panel = null;

    public ContourPlotDemo(String string) {
        super(string);
        JFreeChart jFreeChart = this.createContourPlot();
        this.panel = new ChartPanel(jFreeChart, true, true, true, true, true);
        this.panel.setPreferredSize(new Dimension(500, 270));
        this.panel.setMaximumDrawHeight(100000);
        this.panel.setMaximumDrawWidth(100000);
        this.panel.setFillZoomRectangle(true);
    }

    private JFreeChart createContourPlot() {
        if (xIsDate) {
            this.xAxis = new DateAxis("X Values");
            xIsLog = false;
        } else {
            this.xAxis = xIsLog ? new LogarithmicAxis("X Values") : new NumberAxis("X Values");
        }
        this.yAxis = yIsLog ? new LogarithmicAxis("Y Values") : new NumberAxis("Y Values");
        this.zColorBar = zIsLog ? new ColorBar("Color Values") : new ColorBar("Color Values");
        if (this.xAxis instanceof NumberAxis) {
            ((NumberAxis)this.xAxis).setAutoRangeIncludesZero(false);
            ((NumberAxis)this.xAxis).setInverted(xIsInverted);
        }
        this.yAxis.setAutoRangeIncludesZero(false);
        this.yAxis.setInverted(yIsInverted);
        if (!xIsDate) {
            ((NumberAxis)this.xAxis).setLowerMargin(0.0);
            ((NumberAxis)this.xAxis).setUpperMargin(0.0);
        }
        this.yAxis.setLowerMargin(0.0);
        this.yAxis.setUpperMargin(0.0);
        this.zColorBar.getAxis().setInverted(zIsInverted);
        this.zColorBar.getAxis().setTickMarksVisible(true);
        ContourDataset contourDataset = this.createDataset();
        ContourPlot contourPlot = new ContourPlot(contourDataset, this.xAxis, this.yAxis, this.zColorBar);
        if (xIsDate) {
            ratio = Math.abs(ratio);
        }
        contourPlot.setDataAreaRatio(ratio);
        JFreeChart jFreeChart = new JFreeChart("Contour Plot", null, contourPlot, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        return jFreeChart;
    }

    private ContourDataset createDataset() {
        int n = numX * numY;
        Object[] objectArray = new Date[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        Object[] objectArray2 = new Double[n];
        Object[] objectArray3 = new Double[n];
        Object[] objectArray4 = new Double[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            n4 = i / numX;
            if (n5 != n4) {
                n5 = n4;
                n3 = 0;
                d = 1.005 * d;
            }
            objectArray[i] = new Date((long)((double)(n4 + 100) * 1.0E8));
            dArray[i] = n4 + 2;
            dArray2[i] = d * (double)n3++;
            objectArray2[i] = new Double(dArray[i]);
            objectArray3[i] = new Double(dArray2[i]);
            double d2 = Math.random();
            objectArray4[i] = makeHoles && d2 > 0.4 && d2 < 0.6 ? null : new Double(3.0 * ((dArray[i] + 1.0) * (dArray2[i] + 1.0) + 100.0));
            ++n2;
        }
        DefaultContourDataset defaultContourDataset = null;
        defaultContourDataset = xIsDate ? new DefaultContourDataset((Comparable)((Object)"Contouring"), objectArray, objectArray3, objectArray4) : new DefaultContourDataset((Comparable)((Object)"Contouring"), objectArray2, objectArray3, objectArray4);
        return defaultContourDataset;
    }

    protected static boolean processArgs(String[] stringArray) {
        String[] stringArray2 = new String[]{"-?", "-invert", "-log", "-date", "-vertical", "-holes", "-ratio:", "-numX:", "-numY:"};
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            block12: for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i].startsWith(stringArray2[j])) continue;
                bl = true;
                int n = 0;
                String string = null;
                switch (j) {
                    case 0: {
                        ContourPlotDemo.usage();
                        return false;
                    }
                    case 1: {
                        xIsInverted = true;
                        yIsInverted = true;
                        zIsInverted = true;
                        continue block12;
                    }
                    case 2: {
                        xIsLog = true;
                        yIsLog = true;
                        zIsLog = true;
                        continue block12;
                    }
                    case 3: {
                        xIsDate = true;
                        continue block12;
                    }
                    case 4: {
                        continue block12;
                    }
                    case 5: {
                        makeHoles = true;
                        continue block12;
                    }
                    case 6: {
                        n = stringArray[i].indexOf(58);
                        string = stringArray[i].substring(n + 1);
                        ratio = Double.parseDouble(string);
                        continue block12;
                    }
                    case 7: {
                        n = stringArray[i].indexOf(58);
                        string = stringArray[i].substring(n + 1);
                        numX = Integer.parseInt(string);
                        continue block12;
                    }
                    case 8: {
                        n = stringArray[i].indexOf(58);
                        string = stringArray[i].substring(n + 1);
                        numY = Integer.parseInt(string);
                        continue block12;
                    }
                    default: {
                        System.out.println("Only 9 options available, update options array");
                    }
                }
            }
            if (bl) continue;
            System.out.println("Unknown option: " + stringArray[i]);
            ContourPlotDemo.usage();
            return false;
        }
        return true;
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("ContourPlotDemo -? -invert -log -date -vertical -holes -ratio:value -numX:value -numY:value");
        System.out.println("Where:");
        System.out.println("-? displays usage and exits");
        System.out.println("-invert cause axes to be inverted");
        System.out.println("-log all axes will be logcale");
        System.out.println("-date the X axis will be a date");
        System.out.println("-vertical the colorbar will be drawn vertically");
        System.out.println("-holes demos plotting data with missing values");
        System.out.println("-ratio forces plot to maintain aspect ratio (Y/X) indicated by value");
        System.out.println("       positive values are in pixels, while negative is in plot units");
        System.out.println("-numX number of values to generate along the X axis");
        System.out.println("-numY number of values to generate along the X axis");
    }

    public static void main(String[] stringArray) {
        if (!ContourPlotDemo.processArgs(stringArray)) {
            System.exit(1);
        }
        ContourPlotDemo contourPlotDemo = new ContourPlotDemo("ContourPlot Demo");
        contourPlotDemo.setContentPane(contourPlotDemo.panel);
        contourPlotDemo.pack();
        RefineryUtilities.centerFrameOnScreen(contourPlotDemo);
        contourPlotDemo.setVisible(true);
    }
}

