/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.ui.Spinner;

public class CompassDemo
extends JPanel {
    public static final boolean DEBUG = true;
    public static final String[] NEEDLE_TYPES = new String[]{"Arrow", "Line", "Long", "Pin", "Plum", "Pointer", "Ship", "Wind", "Arrow"};
    private DefaultValueDataset compassData = new DefaultValueDataset(new Double(0.0));
    private DefaultValueDataset shipData = new DefaultValueDataset(new Double(0.0));
    private CompassPlot compassPlot = new CompassPlot(this.compassData);
    private JFreeChart compassChart = new JFreeChart("Compass Test", JFreeChart.DEFAULT_TITLE_FONT, this.compassPlot, false);
    private ChartPanel panelCompass = new ChartPanel(this.compassChart);
    private GridLayout gridLayout1 = new GridLayout();
    private JPanel panelCompassHolder = new JPanel();
    private BorderLayout borderLayout = new BorderLayout();
    private JPanel jPanel12 = new JPanel();
    private JCheckBox windNullCheckBox = new JCheckBox();
    private JCheckBox shipNullCheckBox = new JCheckBox();
    private Spinner spinWind = new Spinner(270);
    private Spinner spinShip = new Spinner(45);
    private JPanel jPanel1 = new JPanel();
    private JComboBox pick1Pointer = new JComboBox<String>(NEEDLE_TYPES);
    private JPanel jPanel2 = new JPanel();
    private JComboBox pick2Pointer = new JComboBox<String>(NEEDLE_TYPES);
    private TitledBorder titledBorder1;
    private TitledBorder titledBorder2;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private TitledBorder titledBorder3;
    private GridLayout gridLayout2 = new GridLayout();

    public CompassDemo() {
        try {
            this.compassPlot.addData(this.shipData);
            this.compassPlot.setSeriesNeedle(0, 7);
            this.compassPlot.setSeriesNeedle(1, 5);
            this.compassPlot.setSeriesPaint(0, Color.blue);
            this.compassPlot.setSeriesOutlinePaint(0, Color.blue);
            this.compassPlot.setSeriesPaint(1, Color.red);
            this.compassPlot.setSeriesOutlinePaint(1, Color.red);
            this.pick1Pointer.setSelectedIndex(7);
            this.pick2Pointer.setSelectedIndex(5);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder("");
        this.titledBorder3 = new TitledBorder("");
        this.setLayout(this.gridLayout1);
        this.panelCompassHolder.setLayout(this.borderLayout);
        this.windNullCheckBox.setHorizontalTextPosition(10);
        this.windNullCheckBox.setText("Null");
        this.windNullCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompassDemo.this.checkWindNullActionPerformed(actionEvent);
            }
        });
        this.shipNullCheckBox.setHorizontalTextPosition(2);
        this.shipNullCheckBox.setText("Null");
        this.shipNullCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompassDemo.this.checkShipNullActionPerformed(actionEvent);
            }
        });
        this.spinShip.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.out.println("compassDemo:spinShipPropertyChange");
                Spinner spinner = (Spinner)propertyChangeEvent.getSource();
                if (spinner.isEnabled()) {
                    CompassDemo.this.shipData.setValue(new Double(spinner.getValue()));
                }
            }
        });
        this.spinWind.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.out.println("compassDemo:spinWindPropertyChange");
                Spinner spinner = (Spinner)propertyChangeEvent.getSource();
                if (spinner.isEnabled()) {
                    CompassDemo.this.compassData.setValue(new Double(spinner.getValue()));
                }
            }
        });
        this.jPanel12.setLayout(this.gridLayout2);
        this.jPanel2.setBorder(this.titledBorder1);
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.jPanel1.setBorder(this.titledBorder2);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.titledBorder1.setTitle("Second Pointer");
        this.titledBorder2.setTitle("First Pointer");
        this.titledBorder3.setTitle("Plot Options");
        this.pick2Pointer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompassDemo.this.pick2PointerActionPerformed(actionEvent);
            }
        });
        this.pick1Pointer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompassDemo.this.pick1PointerActionPerformed(actionEvent);
            }
        });
        this.add((Component)this.panelCompassHolder, null);
        this.panelCompassHolder.add((Component)this.jPanel12, "South");
        this.jPanel12.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.pick1Pointer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.windNullCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.spinWind, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel12.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.pick2Pointer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.shipNullCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.spinShip, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panelCompassHolder.add((Component)this.panelCompass, "Center");
    }

    public static void main(String[] stringArray) {
        CompassDemo compassDemo = new CompassDemo();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new BorderLayout(5, 5));
        jFrame.setDefaultCloseOperation(3);
        jFrame.setTitle("Compass Demo");
        jFrame.getContentPane().add((Component)compassDemo, "Center");
        jFrame.setSize(700, 400);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation((dimension.width - jFrame.getSize().width) / 2, (dimension.height - jFrame.getSize().height) / 2);
        jFrame.setVisible(true);
    }

    public void adjustData(double d) {
        Number number = this.compassData.getValue();
        double d2 = d;
        if (number != null) {
            d2 += number.doubleValue();
        }
        if (d2 > 360.0) {
            d2 = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 360.0;
        }
        this.compassData.setValue(new Double(d2));
    }

    void checkWindNullActionPerformed(ActionEvent actionEvent) {
        System.out.println("CompassDemo:checkWindNull: " + this.windNullCheckBox.isSelected());
        if (this.windNullCheckBox.isSelected()) {
            this.compassData.setValue(null);
            this.spinWind.setEnabled(false);
        } else {
            this.compassData.setValue(new Double(this.spinWind.getValue()));
            this.spinWind.setEnabled(true);
        }
        System.out.println("CompassDemo:checkWindNull: " + this.compassData.getValue());
    }

    void checkShipNullActionPerformed(ActionEvent actionEvent) {
        System.out.println("CompassDemo:checkShipNull: " + this.shipNullCheckBox.isSelected());
        if (this.shipNullCheckBox.isSelected()) {
            this.shipData.setValue(null);
            this.spinShip.setEnabled(false);
        } else {
            this.shipData.setValue(new Double(this.spinShip.getValue()));
            this.spinShip.setEnabled(true);
        }
    }

    void pick2PointerActionPerformed(ActionEvent actionEvent) {
        System.out.println("compassDemo:pick2PointActionPerformed " + actionEvent.getActionCommand() + ",");
        this.compassPlot.setSeriesNeedle(1, this.pick2Pointer.getSelectedIndex());
        this.compassPlot.setSeriesPaint(1, Color.red);
        this.compassPlot.setSeriesOutlinePaint(1, Color.red);
    }

    void pick1PointerActionPerformed(ActionEvent actionEvent) {
        System.out.println("compassDemo:pick1PointActionPerformed " + actionEvent.getActionCommand() + ",");
        this.compassPlot.setSeriesNeedle(0, this.pick1Pointer.getSelectedIndex());
        this.compassPlot.setSeriesPaint(0, Color.blue);
        this.compassPlot.setSeriesOutlinePaint(0, Color.blue);
    }
}

