/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Font;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedRangeCategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CombinedCategoryPlotDemo2
extends ApplicationFrame {
    public CombinedCategoryPlotDemo2(String string) {
        super(string);
        ChartPanel chartPanel = new ChartPanel(this.createChart());
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public CategoryDataset createDataset1() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 1"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 2"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 3"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 4"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 5"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 6"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 7"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"First"), (Comparable)((Object)"Type 8"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 1"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 2"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 3"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 4"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 5"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 6"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 7"));
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Type 8"));
        return defaultCategoryDataset;
    }

    public CategoryDataset createDataset2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(11.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Sector 1"));
        defaultCategoryDataset.addValue(14.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Sector 2"));
        defaultCategoryDataset.addValue(13.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Sector 3"));
        defaultCategoryDataset.addValue(15.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Sector 4"));
        defaultCategoryDataset.addValue(15.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Sector 1"));
        defaultCategoryDataset.addValue(17.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Sector 2"));
        defaultCategoryDataset.addValue(16.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Sector 3"));
        defaultCategoryDataset.addValue(18.0, (Comparable)((Object)"Fourth"), (Comparable)((Object)"Sector 4"));
        return defaultCategoryDataset;
    }

    private JFreeChart createChart() {
        CategoryDataset categoryDataset = this.createDataset1();
        CategoryAxis categoryAxis = new CategoryAxis("Class 1");
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        lineAndShapeRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, null, lineAndShapeRenderer);
        categoryPlot.setDomainGridlinesVisible(true);
        CategoryDataset categoryDataset2 = this.createDataset2();
        CategoryAxis categoryAxis2 = new CategoryAxis("Class 2");
        categoryAxis2.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        CategoryPlot categoryPlot2 = new CategoryPlot(categoryDataset2, categoryAxis2, null, barRenderer);
        categoryPlot2.setDomainGridlinesVisible(true);
        NumberAxis numberAxis = new NumberAxis("Value");
        CombinedRangeCategoryPlot combinedRangeCategoryPlot = new CombinedRangeCategoryPlot(numberAxis);
        combinedRangeCategoryPlot.add(categoryPlot, 3);
        combinedRangeCategoryPlot.add(categoryPlot2, 2);
        combinedRangeCategoryPlot.setOrientation(PlotOrientation.HORIZONTAL);
        JFreeChart jFreeChart = new JFreeChart("Combined Range Category Plot Demo", new Font("SansSerif", 1, 12), combinedRangeCategoryPlot, true);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        CombinedCategoryPlotDemo2 combinedCategoryPlotDemo2 = new CombinedCategoryPlotDemo2("Combined Category Plot Demo 2");
        combinedCategoryPlotDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(combinedCategoryPlotDemo2);
        combinedCategoryPlotDemo2.setVisible(true);
    }
}

