/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.GradientPaint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.MatrixSeriesCollection;
import org.jfree.data.xy.NormalizedMatrixSeries;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BubblyBubblesDemo2
extends ApplicationFrame {
    private static final int SIZE = 10;
    private static final String TITLE = "Population count at grid locations";
    NormalizedMatrixSeries series = this.createInitialSeries();

    public BubblyBubblesDemo2(String string) {
        super(string);
        MatrixSeriesCollection matrixSeriesCollection = new MatrixSeriesCollection(this.series);
        JFreeChart jFreeChart = ChartFactory.createBubbleChart(TITLE, "X", "Y", matrixSeriesCollection, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.yellow));
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setForegroundAlpha(0.5f);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setLowerBound(-0.5);
        NumberAxis numberAxis2 = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis2.setLowerBound(-0.5);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        BubblyBubblesDemo2 bubblyBubblesDemo2 = new BubblyBubblesDemo2(TITLE);
        bubblyBubblesDemo2.pack();
        bubblyBubblesDemo2.setSize(800, 600);
        RefineryUtilities.centerFrameOnScreen(bubblyBubblesDemo2);
        bubblyBubblesDemo2.setVisible(true);
        BubblyBubblesDemo2 bubblyBubblesDemo22 = bubblyBubblesDemo2;
        bubblyBubblesDemo22.getClass();
        UpdaterThread updaterThread = bubblyBubblesDemo22.new UpdaterThread();
        updaterThread.setDaemon(true);
        updaterThread.start();
    }

    private NormalizedMatrixSeries createInitialSeries() {
        NormalizedMatrixSeries normalizedMatrixSeries = new NormalizedMatrixSeries("Sample Grid 1", 10, 10);
        for (int i = 0; i < 30; ++i) {
            int n = (int)(Math.random() * 10.0);
            int n2 = (int)(Math.random() * 10.0);
            double d = Math.random() * 1.0;
            normalizedMatrixSeries.update(n, n2, d);
        }
        normalizedMatrixSeries.setScaleFactor(normalizedMatrixSeries.getItemCount());
        return normalizedMatrixSeries;
    }

    private class UpdaterThread
    extends Thread {
        private UpdaterThread() {
        }

        public void run() {
            this.setPriority(1);
            while (true) {
                int n = (int)(Math.random() * 10.0);
                int n2 = (int)(Math.random() * 10.0);
                double d = Math.random() * 3.0 - 1.0;
                BubblyBubblesDemo2.this.series.update(n, n2, BubblyBubblesDemo2.this.series.get(n, n2) + d);
                try {
                    UpdaterThread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

