/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BarChartDemo5
extends ApplicationFrame {
    public BarChartDemo5(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{1.0, 43.0, 35.0, 58.0, 54.0, 77.0, 71.0, 89.0}, {54.0, 75.0, 63.0, 83.0, 43.0, 46.0, 27.0, 13.0}, {41.0, 33.0, 22.0, 34.0, 62.0, 32.0, 42.0, 34.0}};
        return DatasetUtilities.createCategoryDataset("Series ", "Factor ", (double[][])dArrayArray);
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart("Bar Chart", "Category", "Score (%)", categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.lightGray);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.getRenderer().setSeriesPaint(0, new Color(0, 0, 255));
        categoryPlot.getRenderer().setSeriesPaint(1, new Color(75, 75, 255));
        categoryPlot.getRenderer().setSeriesPaint(2, new Color(150, 150, 255));
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setRange(0.0, 100.0);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        BarChartDemo5 barChartDemo5 = new BarChartDemo5("Bar Chart Demo 5");
        barChartDemo5.pack();
        RefineryUtilities.centerFrameOnScreen(barChartDemo5);
        barChartDemo5.setVisible(true);
    }
}

