/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class BarChartDemo3
extends ApplicationFrame {
    public BarChartDemo3(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{4.0, 3.0, -2.0, 3.0, 6.0}};
        return DatasetUtilities.createCategoryDataset("Series ", "Category ", (double[][])dArrayArray);
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart("Bar Chart Demo 3", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, false, true, false);
        jFreeChart.setBackgroundPaint(Color.lightGray);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setNoDataMessage("NO DATA!");
        CustomRenderer customRenderer = new CustomRenderer(new Paint[]{Color.red, Color.blue, Color.green, Color.yellow, Color.orange, Color.cyan, Color.magenta, Color.blue});
        customRenderer.setItemLabelsVisible(true);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 45.0);
        customRenderer.setPositiveItemLabelPosition(itemLabelPosition);
        categoryPlot.setRenderer(customRenderer);
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        valueAxis.setLowerMargin(0.15);
        valueAxis.setUpperMargin(0.15);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        BarChartDemo3 barChartDemo3 = new BarChartDemo3("Bar Chart Demo 3");
        barChartDemo3.pack();
        RefineryUtilities.centerFrameOnScreen(barChartDemo3);
        barChartDemo3.setVisible(true);
    }

    class CustomRenderer
    extends BarRenderer {
        private Paint[] colors;

        public CustomRenderer(Paint[] paintArray) {
            this.colors = paintArray;
        }

        public Paint getItemPaint(int n, int n2) {
            return this.colors[n2 % this.colors.length];
        }
    }
}

