/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Log;
import org.jfree.util.PrintStreamLogTarget;

public class BarChart3DDemo2
extends ApplicationFrame {
    public BarChart3DDemo2(String string) {
        super(string);
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(23.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"London"));
        defaultCategoryDataset.addValue(14.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"New York"));
        defaultCategoryDataset.addValue(14.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Istanbul"));
        defaultCategoryDataset.addValue(14.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Cairo"));
        defaultCategoryDataset.addValue(13.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"London"));
        defaultCategoryDataset.addValue(19.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"New York"));
        defaultCategoryDataset.addValue(19.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Istanbul"));
        defaultCategoryDataset.addValue(19.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Cairo"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"London"));
        defaultCategoryDataset.addValue(9.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"New York"));
        defaultCategoryDataset.addValue(9.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Istanbul"));
        defaultCategoryDataset.addValue(9.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Cairo"));
        JFreeChart jFreeChart = this.createChart(defaultCategoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D("3D Bar Chart Demo 2", "Category", "Value", categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setForegroundAlpha(1.0f);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        CategoryLabelPositions categoryLabelPositions = categoryAxis.getCategoryLabelPositions();
        CategoryLabelPosition categoryLabelPosition = new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, 0.0, CategoryLabelWidthType.RANGE, 0.3f);
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.replaceLeftPosition(categoryLabelPositions, categoryLabelPosition));
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        Log.getInstance().addTarget(new PrintStreamLogTarget());
        BarChart3DDemo2 barChart3DDemo2 = new BarChart3DDemo2("3D Bar Chart Demo 2");
        barChart3DDemo2.pack();
        RefineryUtilities.centerFrameOnScreen(barChart3DDemo2);
        barChart3DDemo2.setVisible(true);
    }
}

