/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.data.Range;
import org.jfree.ui.Size2D;

public class RectangleConstraintTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(RectangleConstraintTests.class);
    }

    public RectangleConstraintTests(String string) {
        super(string);
    }

    public void testCalculateConstrainedSize() {
        RectangleConstraint rectangleConstraint = RectangleConstraint.NONE;
        Size2D size2D = rectangleConstraint.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)size2D.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)size2D.height, (double)3.4, (double)1.0E-10);
        RectangleConstraint rectangleConstraint2 = new RectangleConstraint(0.0, new Range(0.0, 0.0), LengthConstraintType.NONE, 0.0, new Range(2.0, 3.0), LengthConstraintType.RANGE);
        size2D = rectangleConstraint2.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)size2D.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)size2D.height, (double)3.0, (double)1.0E-10);
        RectangleConstraint rectangleConstraint3 = new RectangleConstraint(0.0, null, LengthConstraintType.NONE, 9.9, null, LengthConstraintType.FIXED);
        size2D = rectangleConstraint3.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)size2D.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)size2D.height, (double)9.9, (double)1.0E-10);
        RectangleConstraint rectangleConstraint4 = new RectangleConstraint(0.0, new Range(2.0, 3.0), LengthConstraintType.RANGE, 0.0, new Range(0.0, 0.0), LengthConstraintType.NONE);
        size2D = rectangleConstraint4.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)size2D.width, (double)2.0, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)size2D.height, (double)3.4, (double)1.0E-10);
        RectangleConstraint rectangleConstraint5 = new RectangleConstraint(0.0, new Range(2.0, 3.0), LengthConstraintType.RANGE, 0.0, new Range(2.0, 3.0), LengthConstraintType.RANGE);
        size2D = rectangleConstraint5.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)size2D.width, (double)2.0, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)size2D.height, (double)3.0, (double)1.0E-10);
        RectangleConstraint rectangleConstraint6 = new RectangleConstraint(0.0, null, LengthConstraintType.NONE, 9.9, null, LengthConstraintType.FIXED);
        size2D = rectangleConstraint6.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)size2D.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)size2D.height, (double)9.9, (double)1.0E-10);
        RectangleConstraint rectangleConstraint7 = RectangleConstraint.NONE;
        size2D = rectangleConstraint7.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)size2D.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)size2D.height, (double)3.4, (double)1.0E-10);
        RectangleConstraint rectangleConstraint8 = new RectangleConstraint(0.0, new Range(0.0, 0.0), LengthConstraintType.NONE, 0.0, new Range(2.0, 3.0), LengthConstraintType.RANGE);
        size2D = rectangleConstraint8.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)size2D.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)size2D.height, (double)3.0, (double)1.0E-10);
        RectangleConstraint rectangleConstraint9 = new RectangleConstraint(0.0, null, LengthConstraintType.NONE, 9.9, null, LengthConstraintType.FIXED);
        size2D = rectangleConstraint9.calculateConstrainedSize(new Size2D(1.2, 3.4));
        RectangleConstraintTests.assertEquals((double)size2D.width, (double)1.2, (double)1.0E-10);
        RectangleConstraintTests.assertEquals((double)size2D.height, (double)9.9, (double)1.0E-10);
    }
}

