/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.block.GridArrangement;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.ui.Size2D;

public class GridArrangementTests
extends TestCase {
    private static final double EPSILON = 1.0E-9;

    public static Test suite() {
        return new TestSuite(GridArrangementTests.class);
    }

    public GridArrangementTests(String string) {
        super(string);
    }

    public void testEquals() {
        GridArrangement gridArrangement = new GridArrangement(11, 22);
        GridArrangement gridArrangement2 = new GridArrangement(11, 22);
        GridArrangementTests.assertTrue((boolean)gridArrangement.equals(gridArrangement2));
        GridArrangementTests.assertTrue((boolean)gridArrangement2.equals(gridArrangement));
        gridArrangement = new GridArrangement(33, 22);
        GridArrangementTests.assertFalse((boolean)gridArrangement.equals(gridArrangement2));
        gridArrangement2 = new GridArrangement(33, 22);
        GridArrangementTests.assertTrue((boolean)gridArrangement.equals(gridArrangement2));
        gridArrangement = new GridArrangement(33, 44);
        GridArrangementTests.assertFalse((boolean)gridArrangement.equals(gridArrangement2));
        gridArrangement2 = new GridArrangement(33, 44);
        GridArrangementTests.assertTrue((boolean)gridArrangement.equals(gridArrangement2));
    }

    public void testCloning() {
        GridArrangement gridArrangement = new GridArrangement(1, 2);
        GridArrangementTests.assertFalse((boolean)(gridArrangement instanceof Cloneable));
    }

    public void testSerialization() {
        GridArrangement gridArrangement = new GridArrangement(33, 44);
        GridArrangement gridArrangement2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(gridArrangement);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            gridArrangement2 = (GridArrangement)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GridArrangementTests.assertEquals((Object)gridArrangement, gridArrangement2);
    }

    public void testNN() {
        BlockContainer blockContainer = this.createTestContainer1();
        Size2D size2D = blockContainer.arrange(null, RectangleConstraint.NONE);
        GridArrangementTests.assertEquals((double)90.0, (double)size2D.width, (double)1.0E-9);
        GridArrangementTests.assertEquals((double)33.0, (double)size2D.height, (double)1.0E-9);
    }

    public void testFN() {
        BlockContainer blockContainer = this.createTestContainer1();
        RectangleConstraint rectangleConstraint = new RectangleConstraint(100.0, null, LengthConstraintType.FIXED, 0.0, null, LengthConstraintType.NONE);
        Size2D size2D = blockContainer.arrange(null, rectangleConstraint);
        GridArrangementTests.assertEquals((double)100.0, (double)size2D.width, (double)1.0E-9);
        GridArrangementTests.assertEquals((double)33.0, (double)size2D.height, (double)1.0E-9);
    }

    private BlockContainer createTestContainer1() {
        EmptyBlock emptyBlock = new EmptyBlock(10.0, 11.0);
        EmptyBlock emptyBlock2 = new EmptyBlock(20.0, 22.0);
        EmptyBlock emptyBlock3 = new EmptyBlock(30.0, 33.0);
        BlockContainer blockContainer = new BlockContainer(new GridArrangement(1, 3));
        blockContainer.add(emptyBlock);
        blockContainer.add(emptyBlock2);
        blockContainer.add(emptyBlock3);
        return blockContainer;
    }
}

